/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb;

import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.adb.DbAccessManager;
import de.mhus.lib.adb.DbDynamic;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.adb.DbObject;
import de.mhus.lib.adb.model.Feature;
import de.mhus.lib.adb.model.FeatureAccessManager;
import de.mhus.lib.adb.model.FeatureCut;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.FieldPersistent;
import de.mhus.lib.adb.model.FieldVirtual;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.adb.model.TableAnnotations;
import de.mhus.lib.adb.model.TableDynamic;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbResult;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;

public abstract class DbSchema
extends MObject {
    protected String tablePrefix = "";

    public abstract Class<?>[] getObjectTypes();

    public void doPostInit(DbManager manager) {
    }

    public void doInit(IConfig config) {
    }

    public String getTableName(String name) {
        return this.tablePrefix + name;
    }

    public Object createObject(Class<?> clazz, String registryName, DbResult ret, DbManager manager) throws Exception {
        Object object = manager.getActivator().createObject(clazz.getCanonicalName());
        if (object instanceof DbObject) {
            ((DbObject)object).doInit(manager, registryName);
        }
        return object;
    }

    public Class<?> findClassForObject(Object object, DbManager manager) {
        for (Class<?> c : this.getObjectTypes()) {
            if (!c.isInstance(object)) continue;
            return c;
        }
        return null;
    }

    public long getUniqueId(Table table, Field field, Object obj, String name, DbManager manager) {
        return MSingleton.instance().nextUniqueId();
    }

    public void doPreCreate(Table table, Object object, DbConnection con, DbManager manager) {
        if (object instanceof DbObject) {
            ((DbObject)object).doInit(manager, table.getRegistryName());
            ((DbObject)object).doPreCreate(con);
        }
    }

    public void doPreSave(Table table, Object object, DbConnection con, DbManager manager) {
        if (object instanceof DbObject) {
            ((DbObject)object).doPreSave(con);
        }
    }

    public boolean hasPersistentInfo() {
        return true;
    }

    public String getSchemaName() {
        return this.getClass().getSimpleName();
    }

    public void doFillNameMapping(HashMap<String, Object> nameMapping) {
    }

    public void doPreRemove(Table table, Object object, DbConnection con, DbManager dbManager) {
        if (object instanceof DbObject) {
            ((DbObject)object).doPreRemove(con);
        }
    }

    public void doPostLoad(Table table, Object object, DbConnection con, DbManager manager) {
        if (object instanceof DbObject) {
            ((DbObject)object).doPostLoad(con);
        }
    }

    public void doPostRemove(Table c, Object object, DbConnection con, DbManager dbManager) {
        if (object instanceof DbObject) {
            ((DbObject)object).doPostRemove(con);
        }
    }

    public void doInitProperties(DbManager dbManager) {
    }

    public void doMigrate(DbManager dbManager, long currentVersion) throws MException {
    }

    public DbAccessManager getAccessManager(Table c) {
        return null;
    }

    public String toString() {
        return this.getSchemaName() + Arrays.deepToString(this.getObjectTypes()) + "@DbSchema";
    }

    public Table createTable(DbManager manager, Class<?> clazz, String registryName, String tableName) {
        boolean isDynamic = true;
        try {
            clazz.asSubclass(DbDynamic.class);
        }
        catch (ClassCastException e) {
            isDynamic = false;
        }
        Table table = null;
        table = isDynamic ? new TableDynamic() : new TableAnnotations();
        table.init(manager, clazz, registryName, tableName);
        return table;
    }

    public Feature createFeature(DbManager manager, Table table, String name) {
        try {
            Feature feature = null;
            name = name.trim().toLowerCase();
            if (name.equals("accesscontrol")) {
                feature = new FeatureAccessManager();
            } else if (name.equals("cut")) {
                feature = new FeatureCut();
            }
            if (feature != null) {
                feature.init(manager, table);
            } else {
                this.log().t("feature not found", name);
            }
            return feature;
        }
        catch (Exception e) {
            this.log().t("feature", name, e);
            return null;
        }
    }

    public Field createField(DbManager manager, Table table, String name, boolean pk, boolean virtual, Method setter, Method getter, Class<?> ret, IConfig attr, DbDynamic.Field dynamicField) {
        Field field = null;
        field = virtual ? new FieldVirtual(table, name, pk, setter, getter, ret, attr) : new FieldPersistent(manager, table, name, pk, setter, getter, ret, attr, dynamicField);
        return field;
    }
}

