/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb;

import de.mhus.lib.MActivator;
import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.MException;
import de.mhus.lib.MString;
import de.mhus.lib.adb.DbCollection;
import de.mhus.lib.adb.DbSchema;
import de.mhus.lib.adb.model.Field;
import de.mhus.lib.adb.model.Table;
import de.mhus.lib.adb.util.DbProperties;
import de.mhus.lib.adb.util.Property;
import de.mhus.lib.cao.util.MetadataBundle;
import de.mhus.lib.cao.util.NoneDriver;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.jmx.MJmx;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPool;
import de.mhus.lib.sql.DbResult;
import de.mhus.lib.sql.DbStatement;
import de.mhus.lib.util.FallbackMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@JmxManaged(descrition="ADB manager information interface")
public class DbManager
extends MJmx {
    public static final String DATABASE_VERSION = "db.version";
    public static final String DATABASE_CREATED = "db.created";
    public static final String DATABASE_MANAGER_VERSION = "db.manager.version";
    public static final String MANAGER_VERSION = "1.0";
    public static final int R_READ = 0;
    public static final int R_CREATE = 1;
    public static final int R_UPDATE = 2;
    public static final int R_REMOVE = 3;
    private DbSchema schema;
    private DbPool pool;
    private HashMap<String, Table> cIndex = new HashMap();
    private HashMap<String, Object> nameMapping;
    private Map<String, Object> nameMappingRO;
    private DbProperties schemaPersistence;
    private MetadataBundle caoBundle;
    private MActivator activator;

    public DbManager(DbPool pool, DbSchema schema) throws Exception {
        this.pool = pool;
        this.schema = schema;
        this.activator = pool.getProvider().getActivator();
        this.initDatabase();
    }

    public DbManager(DbPool pool, DbSchema schema, MActivator activator) throws Exception {
        this.pool = pool;
        this.schema = schema;
        this.activator = activator == null ? pool.getProvider().getActivator() : activator;
        this.initDatabase();
    }

    public <T> DbCollection<T> getByQualification(T object, String qualification, Map<String, Object> attributes) throws MException {
        return this.getByQualification(null, object, null, qualification, attributes);
    }

    public <T> DbCollection<T> getByQualification(DbConnection con, T object, String registryName, String qualification, Map<String, Object> attributes) throws MException {
        Class<?> clazz = this.schema.findClassForObject(object, this);
        return this.executeQuery(con, object, registryName, "SELECT * FROM $db." + clazz.getSimpleName() + "$ " + (MString.isSet(qualification) ? "WHERE " + qualification : ""), attributes);
    }

    public <T> DbCollection<T> executeQuery(T clazz, String query, Map<String, Object> attributes) throws MException {
        return this.executeQuery(null, clazz, null, query, attributes);
    }

    public <T> DbCollection<T> executeQuery(DbConnection con, T clazz, String registryName, String query, Map<String, Object> attributes) throws MException {
        Map<String, Object> map = null;
        DbConnection myCon = null;
        if (con == null) {
            try {
                myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(con, query, attributes, t);
            }
            con = myCon;
        }
        map = attributes == null ? this.nameMappingRO : new FallbackMap<String, Object>(attributes, this.nameMappingRO, true);
        try {
            DbStatement sth = con.createStatement(query);
            DbResult res = sth.executeQuery(map);
            DbCollection<T> dbCollection = new DbCollection<T>(this, con, myCon != null, registryName, clazz, res);
            return dbCollection;
        }
        catch (Throwable t) {
            throw new MException(con, query, attributes, t);
        }
    }

    @JmxManaged(descrition="Database Properties of the Schema")
    public DbProperties getSchemaProperties() {
        return this.schemaPersistence;
    }

    public Object getObject(String registryName, Object ... keys) throws MException {
        return this.getObject(null, registryName, keys);
    }

    public Object getObject(Class<?> clazz, Object ... keys) throws MException {
        return this.getObject(null, clazz.getCanonicalName(), keys);
    }

    public Object getObject(DbConnection con, String registryName, Object ... keys) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            Object out = c.getObject(con, keys);
            if (myCon != null) {
                try {
                    myCon.commit();
                }
                catch (Throwable t) {
                    throw new MException(new Object[]{t});
                }
                myCon.close();
            }
            return out;
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
    }

    void fillObject(String registryName, Object object, DbConnection con, DbResult res) throws MException {
        Table c;
        if (registryName == null) {
            Class<?> clazz = this.getSchema().findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName(), registryName);
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            if (object == null) {
                object = this.schema.createObject(c.getClazz(), registryName, res, this);
            }
            c.fillObject(object, con, res);
            this.schema.doPostLoad(c, object, con, this);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
    }

    public void reloadObject(String registryName, Object object) throws MException {
        this.reloadObject(null, registryName, object);
    }

    public void reloadObject(DbConnection con, String registryName, Object object) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if (registryName == null) {
            Class<?> clazz = this.schema.findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName(), registryName);
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        LinkedList<Object> keys = new LinkedList<Object>();
        try {
            for (Field f : c.getPrimaryKeys()) {
                keys.add(f.getFromTarget(object));
            }
            if (c.fillObject(con, object, keys.toArray()) == null) {
                throw new MException(new Object[]{"object not found"});
            }
            this.schema.doPostLoad(c, object, con, this);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
        if (myCon != null) {
            try {
                myCon.commit();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
            myCon.close();
        }
    }

    public void fillObject(DbConnection con, String registryName, Object object, Object ... keys) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if (registryName == null) {
            Class<?> clazz = this.schema.findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName(), registryName);
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            c.fillObject(con, object, keys);
            this.schema.doPostLoad(c, object, con, this);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
        if (myCon != null) {
            try {
                myCon.commit();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
            myCon.close();
        }
    }

    public void createObject(Object object) throws MException {
        this.createObject(null, null, object);
    }

    public void createObject(String registryName, Object object) throws MException {
        this.createObject(null, registryName, object);
    }

    public void createObject(DbConnection con, Object object) throws MException {
        this.createObject(con, null, object);
    }

    public void createObject(DbConnection con, String registryName, Object object) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if (registryName == null) {
            Class<?> clazz = this.schema.findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName(), registryName);
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            c.prepareCreate(object);
            this.schema.doPreCreate(c, object, con, this);
            c.createObject(con, object);
            this.schema.doPostLoad(c, object, con, this);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
        if (myCon != null) {
            try {
                myCon.commit();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
            myCon.close();
        }
    }

    public void saveObject(Object object) throws MException {
        this.saveObject(null, null, object);
    }

    public void saveObject(String registryName, Object object) throws MException {
        this.saveObject(null, registryName, object);
    }

    public void saveObject(DbConnection con, Object object) throws MException {
        this.saveObject(con, null, object);
    }

    public void saveObject(DbConnection con, String registryName, Object object) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if (registryName == null) {
            Class<?> clazz = this.schema.findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName());
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            this.schema.doPreSave(c, object, con, this);
            c.saveObject(con, object);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
        if (myCon != null) {
            try {
                myCon.commit();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
            myCon.close();
        }
    }

    public void removeObject(Object object) throws MException {
        this.removeObject(null, null, object);
    }

    public void removeObject(String registryName, Object object) throws MException {
        this.removeObject(null, registryName, object);
    }

    public void removeObject(DbConnection con, Object object) throws MException {
        this.removeObject(con, null, object);
    }

    public void removeObject(DbConnection con, String registryName, Object object) throws MException {
        Table c;
        DbConnection myCon = null;
        if (con == null) {
            try {
                con = myCon = this.pool.getConnection();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
        }
        if (registryName == null) {
            Class<?> clazz = this.schema.findClassForObject(object, this);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName());
            }
            registryName = clazz.getCanonicalName();
        }
        if ((c = this.cIndex.get(registryName)) == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        try {
            this.schema.doPreRemove(c, object, con, this);
            c.removeObject(con, object);
            this.schema.doPostRemove(c, object, con, this);
        }
        catch (Throwable t) {
            throw new MException(new Object[]{registryName, t});
        }
        if (myCon != null) {
            try {
                myCon.commit();
            }
            catch (Throwable t) {
                throw new MException(new Object[]{t});
            }
            myCon.close();
        }
    }

    protected void initDatabase() throws Exception {
        Class<?>[] types = this.schema.getObjectTypes();
        DbConnection con = this.pool.getConnection();
        this.cIndex.clear();
        this.nameMapping = new HashMap();
        this.nameMappingRO = Collections.unmodifiableMap(this.nameMapping);
        this.caoBundle = new MetadataBundle(NoneDriver.getInstance());
        if (this.schema.hasPersistentInfo()) {
            this.addClass(this.schema.getSchemaName(), this.schema.getClass().getCanonicalName(), Property.class, con);
            this.schemaPersistence = new DbProperties(this, this.schema.getClass().getCanonicalName());
        }
        for (Class<?> clazz : types) {
            this.addClass(null, clazz.getCanonicalName(), clazz, con);
        }
        con.commit();
        for (Table c : this.cIndex.values()) {
            c.fillNameMapping(this.nameMapping);
        }
        this.schema.doFillNameMapping(this.nameMapping);
        if (this.schemaPersistence != null) {
            String dbVersion = this.schemaPersistence.get(DATABASE_VERSION);
            if (dbVersion == null) {
                this.schemaPersistence.set(DATABASE_VERSION, "0");
                this.schemaPersistence.set(DATABASE_CREATED, new MDate().toString());
                this.schemaPersistence.set(DATABASE_MANAGER_VERSION, MANAGER_VERSION);
                this.schema.doInitProperties(this);
                dbVersion = this.schemaPersistence.get(DATABASE_VERSION);
            }
            long dbVersionLong = MCast.tolong(dbVersion, 0L);
            this.schema.doMigrate(this, dbVersionLong);
        }
    }

    protected void addClass(String tableName, String registryName, Class<?> clazz, DbConnection con) throws Exception {
        Table c = this.schema.createTable(this, clazz, registryName, tableName);
        c.initDatabase(con);
        this.cIndex.put(registryName, c);
    }

    @JmxManaged(descrition="Used Schema")
    public DbSchema getSchema() {
        return this.schema;
    }

    public DbPool getPool() {
        return this.pool;
    }

    public MActivator getActivator() {
        return this.activator;
    }

    @JmxManaged(descrition="Current mapping of the table and column names")
    public Map<String, Object> getNameMapping() {
        return this.nameMappingRO;
    }

    public MetadataBundle getCaoMetadata() {
        return this.caoBundle;
    }

    @JmxManaged(descrition="Returns valide registry names")
    public String[] getRegistryNames() {
        return this.cIndex.keySet().toArray(new String[0]);
    }

    @JmxManaged(descrition="Returns the table for the registry name")
    public Table getTable(String registryName) {
        return this.cIndex.get(registryName);
    }

    public Object createSchemaObject(String registryName) throws Exception {
        Table table = this.cIndex.get(registryName);
        if (table == null) {
            throw new MException("class definition not found in schema", registryName);
        }
        return this.schema.createObject(table.getClazz(), table.getRegistryName(), null, this);
    }
}

