/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.adb;

import de.mhus.lib.MException;
import de.mhus.lib.adb.DbManager;
import de.mhus.lib.logging.MLog;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class DbCollection<O>
implements Iterable<O>,
Iterator<O> {
    private DbManager manager;
    private DbResult res;
    private DbConnection con;
    private String registryName;
    private O object;
    private boolean recycle = false;
    private boolean hasNext = true;
    private boolean ownConnection;

    public DbCollection(DbManager manager, DbConnection con, boolean ownConnection, String registryName, O object, DbResult res) throws MException {
        if (registryName == null) {
            Class<?> clazz = manager.getSchema().findClassForObject(object, manager);
            if (clazz == null) {
                throw new MException("class definition not found for object", object.getClass().getCanonicalName(), registryName);
            }
            registryName = clazz.getCanonicalName();
        }
        this.manager = manager;
        this.res = res;
        this.con = con;
        this.registryName = registryName;
        this.object = object;
        this.ownConnection = ownConnection;
        this.nextObject();
    }

    private void nextObject() {
        if (!this.hasNext) {
            return;
        }
        try {
            this.hasNext = this.res.next();
        }
        catch (Exception e) {
            MLog.w(e);
            this.hasNext = false;
        }
        if (!this.hasNext) {
            this.close();
        }
    }

    public void close() {
        if (this.res == null) {
            return;
        }
        try {
            this.res.close();
        }
        catch (Exception e) {
            MLog.w(e);
        }
        if (this.ownConnection) {
            this.con.close();
        }
        this.res = null;
    }

    public void setRecycle(boolean on) {
        this.recycle = on;
    }

    public boolean isRecycle() {
        return this.recycle;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public O getObject() throws MException {
        Object out = this.object;
        if (!this.recycle) {
            try {
                out = this.manager.getSchema().createObject(this.object.getClass(), this.registryName, this.res, this.manager);
            }
            catch (Throwable t) {
                throw new MException(this.con, t);
            }
        }
        this.manager.fillObject(this.registryName, out, this.con, this.res);
        return out;
    }

    @Override
    public Iterator<O> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public O next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            O out = this.getObject();
            this.nextObject();
            return out;
        }
        catch (MException e) {
            MLog.w(e);
            throw new NoSuchElementException();
        }
    }

    public void addToList(List list) {
        for (O o : this) {
            list.add(o);
        }
    }

    public List<O> toCacheAndClose() {
        LinkedList list = new LinkedList();
        this.addToList(list);
        this.close();
        return list;
    }

    public O[] toArrayAndClose(O[] dummy) {
        List<O> list = this.toCacheAndClose();
        return list.toArray(dummy);
    }
}

