/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MCast;
import de.mhus.lib.MString;
import java.util.Calendar;
import java.util.Date;

public class MTimeInterval {
    public static final long SECOUND_IN_MILLISECOUNDS = 1000L;
    public static final long MINUTE_IN_MILLISECOUNDS = 60000L;
    public static final long HOUR_IN_MILLISECOUNDS = 3600000L;
    public static final long DAY_IN_MILLISECOUNDS = 86400000L;
    public static final long WEEK_IN_MILLISECOUNDS = 604800000L;
    public static final int MILLISECOND = 1;
    public static final int SECOND = 2;
    public static final int MINUTE = 3;
    public static final int HOUR = 4;
    public static final int DAY = 5;
    public static final int WEEK = 6;
    public static final int MONTH = 7;
    public static final int YEAR = 8;
    public static final int DECADE = 9;
    public static final int CENTURY = 10;
    public static final int MILLENIUM = 11;
    private int days = 0;
    private int weeks = 0;
    private int months = 0;
    private int years = 0;
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int millisec = 0;

    public MTimeInterval() {
    }

    public MTimeInterval(String _interval) throws NumberFormatException {
        this();
        this.parse(_interval);
    }

    public void parse(String _interval) throws NumberFormatException {
        StringBuffer buffer = new StringBuffer();
        block12: for (int i = 0; i < _interval.length(); ++i) {
            char c = _interval.charAt(i);
            switch (c) {
                case 'y': {
                    this.add(8, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'm': {
                    this.add(7, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'w': {
                    this.add(6, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'd': {
                    this.add(5, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'h': {
                    this.add(4, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'M': {
                    this.add(3, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 's': {
                    this.add(2, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case 'S': {
                    this.add(1, Integer.parseInt(buffer.toString()));
                    buffer.setLength(0);
                    continue block12;
                }
                case '\t': 
                case ' ': {
                    continue block12;
                }
                case '\n': 
                case '\r': {
                    this.optimize();
                    return;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        this.optimize();
    }

    public void add(int _type, int _value) {
        switch (_type) {
            case 8: {
                this.years += _value;
                break;
            }
            case 7: {
                this.months += _value;
                break;
            }
            case 6: {
                this.weeks += _value;
                break;
            }
            case 5: {
                this.days += _value;
                break;
            }
            case 4: {
                this.hours += _value;
                break;
            }
            case 3: {
                this.minutes += _value;
                break;
            }
            case 2: {
                this.seconds += _value;
                break;
            }
            case 1: {
                this.millisec += _value;
                break;
            }
            case 9: {
                this.years += _value * 10;
                break;
            }
            case 10: {
                this.years += _value * 100;
                break;
            }
            case 11: {
                this.years += _value * 1000;
            }
        }
    }

    public void optimize() {
        if (this.millisec >= 100) {
            this.seconds += this.millisec / 100;
            this.millisec %= 100;
        }
        if (this.seconds >= 60) {
            this.minutes += this.seconds / 60;
            this.seconds %= 60;
        }
        if (this.minutes >= 60) {
            this.hours += this.minutes / 60;
            this.minutes %= 60;
        }
        if (this.hours >= 24) {
            this.days += this.hours / 24;
            this.hours %= 24;
        }
        if (this.days >= 7) {
            this.weeks += this.weeks / 7;
            this.days %= 7;
        }
        if (this.months >= 12) {
            this.years += this.months / 12;
            this.months %= 12;
        }
        if (this.millisec <= -100) {
            this.seconds += this.millisec / 100;
            this.millisec = -(-this.millisec % 100);
        }
        if (this.seconds <= -60) {
            this.minutes += this.seconds / 60;
            this.seconds = -(-this.seconds % 60);
        }
        if (this.minutes <= -60) {
            this.hours += this.minutes / 60;
            this.minutes = -(-this.minutes % 60);
        }
        if (this.hours <= -24) {
            this.days += this.hours / 24;
            this.hours = -(-this.hours % 24);
        }
        if (this.days <= -7) {
            this.weeks += this.weeks / 7;
            this.days = -(-this.days % 7);
        }
        if (this.months <= -12) {
            this.years += this.months / 12;
            this.months = -(-this.months % 12);
        }
    }

    public Date join(Date _date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(_date);
        this.join(cal);
        return cal.getTime();
    }

    public void join(Calendar _cal) {
        _cal.add(14, this.millisec);
        _cal.add(13, this.seconds);
        _cal.add(12, this.minutes);
        _cal.add(10, this.hours);
        _cal.add(5, this.days + this.weeks * 7);
        _cal.add(2, this.months);
        _cal.add(1, this.years);
    }

    public String toString() {
        return "" + this.years + "y " + this.months + "m " + this.weeks + "w " + this.days + "d " + this.hours + "h " + this.minutes + "M " + this.seconds + "s " + this.millisec + "S";
    }

    public static long toMilliseconds(String interval, int def) {
        if (interval == null) {
            return def;
        }
        try {
            String msec = null;
            String sec = null;
            String min = null;
            String hour = null;
            String day = null;
            if (interval.indexOf(58) > 0) {
                String[] parts = MString.split(interval, ":");
                if (parts.length == 3) {
                    hour = parts[0];
                    min = parts[1];
                    sec = parts[2];
                } else if (parts.length == 2) {
                    min = parts[0];
                    sec = parts[1];
                }
            } else {
                sec = interval;
            }
            if (hour != null && hour.indexOf(32) > 0) {
                day = MString.beforeIndex(hour, ' ');
                hour = MString.afterIndex(hour, ' ');
            }
            if (sec != null && sec.indexOf(46) > 0) {
                msec = MString.afterIndex(sec, '.');
                sec = MString.beforeIndex(sec, '.');
            }
            long out = 0L;
            if (day != null) {
                out += MCast.tolong(day, 0L) * 86400000L;
            }
            if (hour != null) {
                out += MCast.tolong(hour, 0L) * 3600000L;
            }
            if (min != null) {
                out += MCast.tolong(min, 0L) * 60000L;
            }
            if (sec != null) {
                out += MCast.tolong(sec, 0L) * 1000L;
            }
            if (msec != null) {
                out += MCast.tolong(msec, 0L);
            }
            return out;
        }
        catch (Throwable throwable) {
            return def;
        }
    }
}

