/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MCast;
import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;

public class MString {
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_UTF_16 = "UTF-16";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    public static final char[] WHITESPACE = new char[]{' ', '\n', '\r', '\t'};
    public static final String DEFAULT_SEPARATOR = ",";
    private static final String[] DEFAULT_SELECTION_SEPARATOR = new String[]{"\n\n"};

    public static boolean isSetTrim(String _in) {
        return !MString.isEmptyTrim(_in);
    }

    public static boolean isSet(String _in) {
        return !MString.isEmpty(_in);
    }

    public static boolean isEmpty(String _in) {
        return _in == null || _in.length() == 0;
    }

    public static String[] split(String _in, String _pattern) {
        if (_in == null) {
            return new String[0];
        }
        int nr = 0;
        int offset = 0;
        while ((offset = _in.indexOf(_pattern, offset)) != -1) {
            ++nr;
            offset += _pattern.length();
        }
        String[] out = new String[nr + 1];
        nr = 0;
        offset = 0;
        int oldOffset = 0;
        while ((offset = _in.indexOf(_pattern, offset)) != -1) {
            out[nr] = _in.substring(oldOffset, offset);
            ++nr;
            oldOffset = offset += _pattern.length();
        }
        out[nr] = _in.substring(oldOffset);
        return out;
    }

    public static String[] splitIgnoreEmpty(String _in, String _pattern) {
        return MString.splitIgnoreEmpty(_in, _pattern, false);
    }

    public static String[] splitIgnoreEmpty(String _in, String _pattern, boolean trim) {
        String s;
        if (_in == null) {
            return new String[0];
        }
        int offset = 0;
        int oldOffset = 0;
        Vector<String> out = new Vector<String>();
        while ((offset = _in.indexOf(_pattern, offset)) != -1) {
            s = _in.substring(oldOffset, offset);
            if (trim) {
                s = s.trim();
            }
            if (s.length() != 0) {
                out.add(s);
            }
            oldOffset = offset += _pattern.length();
        }
        s = _in.substring(oldOffset);
        if (s.length() != 0) {
            out.add(s);
        }
        return out.toArray(new String[out.size()]);
    }

    public static String replaceAll(String _src, String _pattern, String _replacement) {
        StringBuffer sb = new StringBuffer(_src);
        MString.replaceAll(sb, _pattern, _replacement);
        return sb.toString();
    }

    public static void replaceAll(StringBuffer _src, String _pattern, String _replacement) {
        int offset = 0;
        int len = _pattern.length();
        int diff = _replacement.length() - len + 1;
        while ((offset = _src.indexOf(_pattern, offset)) >= 0) {
            _src.replace(offset, offset + len, _replacement);
            offset += diff;
        }
    }

    public static boolean isIndex(String _s, char _c) {
        return _s.indexOf(_c) >= 0;
    }

    public static String beforeIndex(String _s, char _c) {
        if (!MString.isIndex(_s, _c)) {
            return "";
        }
        return _s.substring(0, _s.indexOf(_c));
    }

    public static String afterIndex(String _s, char _c) {
        if (!MString.isIndex(_s, _c)) {
            return "";
        }
        return _s.substring(_s.indexOf(_c) + 1);
    }

    public static boolean isIndex(String _s, char[] _c) {
        for (int i = 0; i < _c.length; ++i) {
            if (_s.indexOf(_c[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static String beforeIndex(String _s, char[] _c) {
        int p = -1;
        for (int i = 0; i < _c.length; ++i) {
            p = _s.indexOf(_c[i]);
            if (p < 0) continue;
            return _s.substring(0, p);
        }
        return "";
    }

    public static String afterIndex(String _s, char[] _c) {
        int p = -1;
        for (int i = 0; i < _c.length; ++i) {
            p = _s.indexOf(_c[i]);
            if (p < 0) continue;
            return _s.substring(p + 1);
        }
        return "";
    }

    public static int indexOf(String _s, char[] _c, int offset) {
        for (int i = offset; i < _s.length(); ++i) {
            char c = _s.charAt(i);
            for (int j = 0; j < _c.length; ++j) {
                if (c != _c[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(String _s, char[] _c) {
        return MString.indexOf(_s, _c, 0);
    }

    public static String encodeWebUnicode(String _in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c > '\u00ff') {
                out.append("&#" + c + ";");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static boolean isUnicode(String _in, char _joker) {
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c <= '\u00ff' && c != _joker) continue;
            return true;
        }
        return false;
    }

    public static String encodeUnicode(String _in) {
        if (_in == null) {
            return "";
        }
        if (!MString.isUnicode(_in, '\\')) {
            return _in;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c > '\u00ff') {
                out.append("\\u" + MCast.toHex2String(c / 256) + MCast.toHex2String(c % 256));
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String encodeURIComponent(String _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '(' || c == ')') {
                out.append(c);
                continue;
            }
            out.append('%' + MCast.toHex2String(c));
        }
        return out.toString();
    }

    public static String decodeUnicode(String _in) {
        int mode = 0;
        byte[] buffer = new byte[4];
        if (_in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        block8: for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            switch (mode) {
                case 0: {
                    if (c == '\\') {
                        mode = 1;
                        continue block8;
                    }
                    out.append(c);
                    continue block8;
                }
                case 1: {
                    if (c == 'u') {
                        mode = 2;
                        continue block8;
                    }
                    if (c == 'n') {
                        out.append('\n');
                        mode = 0;
                        continue block8;
                    }
                    if (c == 'r') {
                        out.append('\r');
                        mode = 0;
                        continue block8;
                    }
                    if (c == 't') {
                        out.append('\t');
                        mode = 0;
                        continue block8;
                    }
                    out.append(92 + c);
                    continue block8;
                }
                case 2: {
                    buffer[0] = (byte)c;
                    mode = 3;
                    continue block8;
                }
                case 3: {
                    buffer[1] = (byte)c;
                    mode = 4;
                    continue block8;
                }
                case 4: {
                    buffer[2] = (byte)c;
                    mode = 5;
                    continue block8;
                }
                case 5: {
                    buffer[3] = (byte)c;
                    out.append((char)MCast.tointFromHex(new String(buffer)));
                    mode = 0;
                }
            }
        }
        return out.toString();
    }

    public static String decodeURIComponent(String _in) {
        int mode = 0;
        byte[] buffer = new byte[2];
        if (_in == null) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        block5: for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            switch (mode) {
                case 0: {
                    if (c == '%') {
                        mode = 1;
                        continue block5;
                    }
                    out.append(c);
                    continue block5;
                }
                case 1: {
                    buffer[0] = (byte)c;
                    mode = 2;
                    continue block5;
                }
                case 2: {
                    buffer[1] = (byte)c;
                    out.append((char)MCast.tointFromHex(new String(buffer)));
                    mode = 0;
                }
            }
        }
        return out.toString();
    }

    public static String encodeCSVLine(String[] _fields) {
        if (_fields == null || _fields.length == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < _fields.length; ++i) {
            if (i != 0) {
                out.append(',');
            }
            out.append(MString.encodeCSV(_fields[i]));
        }
        return out.toString();
    }

    public static String encodeCSV(String _field) {
        if (_field == null) {
            return "\"\"";
        }
        return '\"' + _field.replaceAll("\\\"", "\"\"") + '\"';
    }

    public static String decodeCSV(String _field) {
        if (_field == null || _field.length() == 0) {
            return "";
        }
        if ((_field = _field.trim()).startsWith("\"") && _field.endsWith("\"")) {
            _field = _field.substring(1, _field.length() - 1);
        }
        if (_field.length() == 0) {
            return "";
        }
        return _field.replaceAll("\\\"\\\"", "\"");
    }

    public static boolean compareRegexPattern(String str, String pattern) {
        if (str == null || pattern == null) {
            return false;
        }
        return str.matches(pattern);
    }

    public static boolean compareSQLLikePattern(String str, String pattern) {
        if (str == null || pattern == null) {
            return false;
        }
        return pattern.endsWith("%") && pattern.startsWith("%") ? str.indexOf(pattern.substring(1, pattern.length() - 2)) >= 0 : (pattern.startsWith("%") ? str.endsWith(pattern.substring(1)) : (pattern.endsWith("%") ? str.startsWith(pattern.substring(0, pattern.length() - 1)) : pattern.equals(str)));
    }

    public static boolean compareFsLikePattern(String str, String pattern) {
        if (str == null || pattern == null) {
            return false;
        }
        boolean ret = true;
        if (pattern.startsWith("!")) {
            ret = false;
            pattern = pattern.substring(1);
        }
        if (pattern.equals("*")) {
            return ret;
        }
        if (pattern.endsWith("*") && pattern.startsWith("*") ? str.indexOf(pattern.substring(1, pattern.length() - 2)) >= 0 : (pattern.startsWith("*") ? str.endsWith(pattern.substring(1)) : (pattern.endsWith("*") ? str.startsWith(pattern.substring(0, pattern.length() - 1)) : pattern.equals(str)))) {
            return ret;
        }
        return !ret;
    }

    public static String replaceSQLLikePattern(String str, String pattern, String replace) {
        if (pattern.endsWith("%") && pattern.startsWith("%")) {
            int pos = str.indexOf(pattern.substring(1, pattern.length() - 2));
            if (pos >= 0) {
                return str.substring(0, pos) + replace + str.substring(pos + pattern.length() - 2);
            }
        } else if (pattern.startsWith("%")) {
            if (str.endsWith(pattern.substring(1))) {
                return str.substring(0, str.length() - pattern.length() + 1) + replace;
            }
        } else if (pattern.endsWith("%")) {
            if (str.startsWith(pattern.substring(0, pattern.length() - 1))) {
                return replace + str.substring(pattern.length() - 1);
            }
        } else if (pattern.equals(str)) {
            return replace;
        }
        return str;
    }

    public static String join(String[] src, char glue) {
        if (src == null) {
            return null;
        }
        if (src.length == 0) {
            return "";
        }
        if (src.length == 1) {
            return src[0];
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            if (i != 0) {
                sb.append(glue);
            }
            sb.append(src[i]);
        }
        return sb.toString();
    }

    public static String join(Iterator<String> src, String glue) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (src.hasNext()) {
            if (i != 0) {
                sb.append(glue);
            }
            ++i;
            sb.append(src.next());
        }
        return sb.toString();
    }

    public static String canonical(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static String condense(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf("  ") < 0) {
            return s;
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len - 1);
        boolean suppressSpaces = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                if (suppressSpaces) continue;
                b.append(c);
                suppressSpaces = true;
                continue;
            }
            b.append(c);
            suppressSpaces = false;
        }
        return b.toString();
    }

    public static int countLeading(String text, char c) {
        int count;
        for (count = 0; count < text.length() && text.charAt(count) == c; ++count) {
        }
        return count;
    }

    public static int countTrailing(String text, char c) {
        int count;
        int length = text.length();
        for (count = 0; count < length && text.charAt(length - 1 - count) == c; ++count) {
        }
        return count;
    }

    public static boolean isEmptyTrim(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isLegal(String candidate, String legalChars) {
        for (int i = 0; i < candidate.length(); ++i) {
            if (legalChars.indexOf(candidate.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnaccentedLowerCase(char c) {
        return 'a' <= c && c <= 'z';
    }

    public static boolean isUnaccentedUpperCase(char c) {
        return 'A' <= c && c <= 'Z';
    }

    public static String leftPad(String s, int newLen, boolean chop) {
        int grow = newLen - s.length();
        if (grow <= 0) {
            if (chop) {
                return s.substring(0, newLen);
            }
            return s;
        }
        if (grow <= 30) {
            return "                              ".substring(0, grow) + s;
        }
        return MString.rep(' ', grow) + s;
    }

    public static long parseDirtyLong(String numStr) {
        numStr = numStr.trim();
        StringBuffer b = new StringBuffer(numStr.length());
        boolean negative = false;
        for (int i = 0; i < numStr.length(); ++i) {
            char c = numStr.charAt(i);
            if (c == '-') {
                negative = true;
                continue;
            }
            if ('0' > c || c > '9') continue;
            b.append(c);
        }
        numStr = b.toString();
        if (numStr.length() == 0) {
            return 0L;
        }
        long num = Long.parseLong(numStr);
        if (negative) {
            num = -num;
        }
        return num;
    }

    public static long parseLongPennies(String numStr) {
        numStr = numStr.trim();
        StringBuffer b = new StringBuffer(numStr.length());
        boolean negative = false;
        int decpl = -1;
        block5: for (int i = 0; i < numStr.length(); ++i) {
            char c = numStr.charAt(i);
            switch (c) {
                case '-': {
                    negative = true;
                    continue block5;
                }
                case '.': {
                    if (decpl == -1) {
                        decpl = 0;
                        continue block5;
                    }
                    throw new NumberFormatException("more than one decimal point");
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (decpl != -1) {
                        ++decpl;
                    }
                    b.append(c);
                    continue block5;
                }
            }
        }
        if (numStr.length() != b.length()) {
            numStr = b.toString();
        }
        if (numStr.length() == 0) {
            return 0L;
        }
        long num = Long.parseLong(numStr);
        if (decpl == -1 || decpl == 0) {
            num *= 100L;
        } else if (decpl != 2) {
            throw new NumberFormatException("wrong number of decimal places.");
        }
        if (negative) {
            num = -num;
        }
        return num;
    }

    public static String penniesToString(long pennies) {
        boolean negative;
        if (pennies < 0L) {
            pennies = -pennies;
            negative = true;
        } else {
            negative = false;
        }
        String s = Long.toString(pennies);
        int len = s.length();
        switch (len) {
            case 1: {
                s = "0.0" + s;
                break;
            }
            case 2: {
                s = "0." + s;
                break;
            }
            default: {
                s = s.substring(0, len - 2) + "." + s.substring(len - 2, len);
            }
        }
        if (negative) {
            s = "-" + s;
        }
        return s;
    }

    public static int pluck(String s) {
        int result = 0;
        try {
            result = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static String rep(char c, int count) {
        char[] s = new char[count];
        for (int i = 0; i < count; ++i) {
            s[i] = c;
        }
        return new String(s).intern();
    }

    public static String rightPad(String s, int newLen, boolean chop) {
        int grow = newLen - s.length();
        if (grow <= 0) {
            if (chop) {
                return s.substring(0, newLen);
            }
            return s;
        }
        if (grow <= 30) {
            return s + "                              ".substring(0, grow);
        }
        return s + MString.rep(' ', grow);
    }

    public static String squish(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).indexOf(32) < 0) {
            return s;
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len - 1);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ') continue;
            b.append(c);
        }
        return b.toString();
    }

    public static String toBookTitleCase(String s) {
        char[] ca = s.toCharArray();
        boolean changed = false;
        boolean capitalise = true;
        boolean firstCap = true;
        for (int i = 0; i < ca.length; ++i) {
            char newLetter;
            char oldLetter = ca[i];
            if (oldLetter <= '/' || ':' <= oldLetter && oldLetter <= '?' || ']' <= oldLetter && oldLetter <= '`') {
                capitalise = true;
                continue;
            }
            if (capitalise && !firstCap) {
                capitalise = !s.substring(i, Math.min(i + 4, s.length())).equalsIgnoreCase("the ") && !s.substring(i, Math.min(i + 3, s.length())).equalsIgnoreCase("of ") && !s.substring(i, Math.min(i + 3, s.length())).equalsIgnoreCase("to ");
            }
            ca[i] = newLetter = capitalise ? Character.toUpperCase(oldLetter) : Character.toLowerCase(oldLetter);
            changed |= newLetter != oldLetter;
            capitalise = false;
            firstCap = false;
        }
        if (changed) {
            s = new String(ca);
        }
        return s;
    }

    public static String toHexString(int h) {
        String s = Integer.toHexString(h);
        if (s.length() < 8) {
            s = "00000000".substring(0, 8 - s.length()) + s;
        }
        return "0x" + s;
    }

    public static String toLZ(int i, int len) {
        String s = Integer.toString(i);
        if (s.length() > len) {
            return s.substring(s.length() - len);
        }
        if (s.length() < len) {
            return "000000000000000000000000000000".substring(0, len - s.length()) + s;
        }
        return s;
    }

    public static String toString(Color c) {
        String s = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        if (s.length() < 6) {
            s = "000000".substring(0, 6 - s.length()) + s;
        }
        return '#' + s;
    }

    public static String trimLeading(String s) {
        int st;
        if (s == null) {
            return null;
        }
        int len = s.length();
        for (st = 0; st < len && s.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? s.substring(st, len) : s;
    }

    public static String trimTrailing(String s) {
        int len;
        if (s == null) {
            return null;
        }
        int origLen = len = s.length();
        while (len > 0 && s.charAt(len - 1) <= ' ') {
            --len;
        }
        return len != origLen ? s.substring(0, len) : s;
    }

    public static boolean equals(String in1, String in2) {
        return in1 == null && in2 == null || in1 != null && in1.equals(in2);
    }

    public static String getPart(String value, int nr, String def) {
        return MString.getPart(value, DEFAULT_SEPARATOR, nr, def);
    }

    public static String getPart(String value, int nr) {
        return MString.getPart(value, DEFAULT_SEPARATOR, nr);
    }

    public static String getPart(String value, String separator, int nr, String def) {
        String ret = MString.getPart(value, separator, nr);
        return ret == null ? def : ret;
    }

    public static String getPart(String value, String separator, int nr) {
        if (value == null) {
            return null;
        }
        String[] parts = value.split(separator);
        if (parts.length <= nr) {
            return null;
        }
        return parts[nr];
    }

    public static String beforeLastIndex(String string, char c) {
        if (string == null) {
            return null;
        }
        int pos = string.lastIndexOf(c);
        if (pos < 0) {
            return string;
        }
        return string.substring(0, pos);
    }

    public static String afterLastIndex(String string, char c) {
        if (string == null) {
            return null;
        }
        int pos = string.lastIndexOf(c);
        if (pos < 0) {
            return string;
        }
        return string.substring(pos + 1);
    }

    public static String truncate(String in, int length) {
        if (in.length() <= length) {
            return in;
        }
        return in.substring(0, length);
    }

    public static String truncateNice(String in, int length) {
        if (in.length() <= length) {
            return in;
        }
        if (length < 4) {
            return in.substring(0, length);
        }
        if (in.length() - length > 8) {
            return in.substring(0, length - 8) + "..." + in.substring(in.length() - 5, 5);
        }
        return in.substring(0, length - 3) + "...";
    }

    public static int[] getSelectedPart(String text, int caretPosition) {
        return MString.getSelectedPart(text, caretPosition, DEFAULT_SELECTION_SEPARATOR);
    }

    public static int[] getSelectedPart(String text, int caretPosition, String[] separators) {
        String s = text;
        if (s == null || caretPosition > text.length()) {
            return null;
        }
        int start = -1;
        int near = -1;
        String usedSep = null;
        for (String separator : separators) {
            int cur = s.lastIndexOf(separator, caretPosition);
            if (cur + separator.length() <= near) continue;
            near = cur + separator.length();
            start = cur;
            usedSep = separator;
        }
        start = start < 0 ? 0 : (start += usedSep.length());
        int end = Integer.MAX_VALUE;
        for (String separator : separators) {
            int cur = s.indexOf(separator, caretPosition);
            if (cur < 0) continue;
            end = Math.min(end, cur);
        }
        if (end < 0) {
            end = s.length();
        }
        return new int[]{start, end};
    }

    public static String getSelection(String text, int[] part, String def) {
        if (text == null || part == null || part.length < 2) {
            return def;
        }
        int start = part[0];
        int end = part[1];
        if (end > text.length()) {
            end = text.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (start >= end) {
            return def;
        }
        return text.substring(start, end);
    }

    public static String replaceSelection(String text, int[] part, String replacement) {
        if (text == null || part == null || part.length < 2 || replacement == null) {
            return null;
        }
        int start = part[0];
        int end = part[1];
        if (end > text.length()) {
            end = text.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (start >= end) {
            return null;
        }
        return text.substring(0, start) + replacement + text.substring(end);
    }

    public static void appendRepeating(int amount, char fill, StringBuffer buffer) {
        for (int i = 0; i < amount; ++i) {
            buffer.append(fill);
        }
    }

    public static String getRepeatig(int amount, char fill) {
        StringBuffer buffer = new StringBuffer();
        MString.appendRepeating(amount, fill, buffer);
        return buffer.toString();
    }
}

