/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MActivator;
import de.mhus.lib.MArgs;
import de.mhus.lib.MEventHandler;
import de.mhus.lib.MFile;
import de.mhus.lib.MHousekeeper;
import de.mhus.lib.MPassword;
import de.mhus.lib.MSystem;
import de.mhus.lib.MThreadManager;
import de.mhus.lib.cao.CaoFactory;
import de.mhus.lib.config.ConfigUtil;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.console.Console;
import de.mhus.lib.jmx.MRemoteManager;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.logging.ConsoleFactory;
import de.mhus.lib.logging.Log;
import de.mhus.lib.logging.MLog;
import de.mhus.lib.persistence.MPersistenceManager;
import de.mhus.lib.resources.MResources;
import de.mhus.lib.sql.DbPoolBundle;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;

public class MSingleton
extends MObject {
    private static MSingleton singleton = new MSingleton();
    protected IConfig config = null;
    protected MActivator activator = new MActivator();
    protected MEventHandler<Observer> configChangeObserver = new MEventHandler();
    protected Log logFactory = new ConsoleFactory();
    protected MHousekeeper housekeeper = null;
    protected CaoFactory caoFactory = null;
    protected DbPoolBundle dbPool = null;
    protected Map<String, Object> objects = new HashMap<String, Object>();
    protected MRemoteManager remoteManager = null;
    protected MArgs args = null;
    protected String defaultConfigFile = null;
    protected Console console = null;
    protected MPersistenceManager persistence = null;
    protected MThreadManager threadManager;
    protected int uniqueId = 0;
    protected MResources resources;
    protected File applicationDirectory;
    private String applicationName;

    public MSingleton() {
        this(singleton);
    }

    protected MSingleton(MSingleton singleton) {
        if (singleton != null) {
            this.activator = singleton.activator;
            this.configChangeObserver = singleton.configChangeObserver;
            this.config = singleton.config;
            this.logFactory = singleton.logFactory;
            this.housekeeper = singleton.housekeeper;
            this.threadManager = singleton.threadManager;
            this.caoFactory = singleton.caoFactory;
            this.dbPool = singleton.dbPool;
            this.objects = singleton.objects;
            this.remoteManager = singleton.remoteManager;
            this.args = singleton.args;
            this.uniqueId = singleton.uniqueId;
            this.defaultConfigFile = singleton.defaultConfigFile;
            this.resources = singleton.resources;
            this.console = singleton.console;
            this.persistence = singleton.persistence;
            this.applicationDirectory = singleton.applicationDirectory;
            this.applicationName = singleton.applicationName;
        }
    }

    protected void destroy() {
        for (Object obj : this.objects.values()) {
            if (!(obj instanceof Closeable)) continue;
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        }
        this.objects = null;
        if (this.remoteManager != null) {
            this.remoteManager.close();
        }
        this.remoteManager = null;
        if (this.housekeeper != null) {
            this.housekeeper.finalize();
        }
        this.housekeeper = null;
        this.threadManager = null;
        this.activator = null;
        this.config = null;
        this.configChangeObserver = null;
        this.logFactory = null;
        this.caoFactory = null;
        if (this.dbPool != null) {
            this.dbPool.close();
        }
        this.dbPool = null;
        singleton = new MSingleton(null);
        this.defaultConfigFile = null;
        if (this.persistence != null) {
            this.persistence.close();
        }
        this.persistence = null;
    }

    protected static void setInstance(MSingleton inst) {
        if (inst != null) {
            singleton = inst;
        }
    }

    public static MSingleton instance() {
        return singleton;
    }

    public synchronized IConfig getConfig(Object obj, IConfig def) {
        IConfig out = null;
        if (obj != null) {
            out = obj instanceof Class ? this.getConfig().getConfig(((Class)obj).getCanonicalName()) : this.getConfig().getConfig(obj.getClass().getCanonicalName());
        }
        if (out == null) {
            out = def;
        }
        if (out == null) {
            return null;
        }
        if (!ConfigUtil.checkCondition(out)) {
            return null;
        }
        return out;
    }

    public synchronized IConfig getConfig() {
        if (this.config == null) {
            this.config = new HashConfig();
        }
        return this.config;
    }

    public MActivator getActivator() {
        return this.activator;
    }

    public void registerConfigListener(Observer listener) {
        this.configChangeObserver.registerWeak(listener);
    }

    public void unregisterConfigListener(Observer listener) {
        this.configChangeObserver.unregister(listener);
    }

    protected void fireConfigChanged() {
        for (Object listener : this.configChangeObserver.getListenersArray()) {
            ((Observer)listener).update(null, this.config);
        }
    }

    public Log getLog() {
        return this.logFactory;
    }

    public void setLogFactory(Log log) {
        this.logFactory = log;
        MLog.reset();
    }

    public synchronized MHousekeeper getHousekeeper() {
        if (this.housekeeper == null) {
            this.housekeeper = new MHousekeeper();
        }
        return this.housekeeper;
    }

    public synchronized MThreadManager getThreadManager() {
        if (this.threadManager == null) {
            this.threadManager = new MThreadManager();
        }
        return this.threadManager;
    }

    public synchronized CaoFactory getCaoFactory() {
        if (this.caoFactory == null) {
            this.caoFactory = new CaoFactory();
        }
        return this.caoFactory;
    }

    public synchronized DbPoolBundle getDbPool() {
        if (this.dbPool == null) {
            this.dbPool = new DbPoolBundle();
        }
        return this.dbPool;
    }

    public Object setObject(String key, Object object) {
        if (key == null) {
            return null;
        }
        if (object == null) {
            return this.objects.remove(key);
        }
        return this.objects.put(key, object);
    }

    public Object getObject(String key) {
        return this.objects.get(key);
    }

    public synchronized MRemoteManager getJmxManager() {
        if (this.remoteManager == null) {
            this.remoteManager = new MRemoteManager();
        }
        return this.remoteManager;
    }

    public boolean isJmx() {
        return this.remoteManager != null;
    }

    public void setArguments(String[] args) {
        if (this.args != null) {
            return;
        }
        this.args = new MArgs(args);
        this.log().t("set args", this.args);
    }

    public MArgs getArguments() {
        return this.args;
    }

    public long nextUniqueId() {
        return this.uniqueId++;
    }

    public void setDefaultConfigFile(String name) {
        this.defaultConfigFile = name;
    }

    public MResources getResources() {
        if (this.resources == null) {
            this.resources = new MResources();
        }
        return this.resources;
    }

    public Console getConsole() {
        if (this.console == null) {
            this.console = Console.create();
        }
        return this.console;
    }

    public void setConsole(Console console) {
        this.log().t("set console", console);
        this.console = console;
    }

    public boolean hasSuperPrivileges(String secret) {
        if (secret == null) {
            return false;
        }
        return secret.equals(MPassword.decode(MSingleton.instance().getConfig().getString("secret", null)));
    }

    public boolean isPersistence() {
        return this.persistence != null && this.persistence.isActive();
    }

    public MPersistenceManager getPersistenceManager() {
        return this.persistence;
    }

    public File getApplicationDirectory() {
        if (this.applicationDirectory == null) {
            String appDir = this.getConfig().getExtracted("application_directory");
            if (appDir == null) {
                appDir = MSystem.getTmpDirectory();
                appDir = appDir + File.separatorChar + MFile.normalize(this.getApplicationName());
            }
            this.applicationDirectory = new File(appDir);
        }
        return this.applicationDirectory;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            String appName = this.getConfig().getExtracted("application_name");
            if (appName == null) {
                for (StackTraceElement[] stack : Thread.getAllStackTraces().values()) {
                    StackTraceElement main = stack[stack.length - 1];
                    if (!main.getMethodName().equals("main")) continue;
                    appName = main.getClassName();
                    break;
                }
            }
            if (appName == null) {
                appName = "unknown";
            }
            this.applicationName = appName;
        }
        return this.applicationName;
    }
}

