/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MHousekeeperTask;
import de.mhus.lib.MTimer;
import de.mhus.lib.MTimerTask;
import de.mhus.lib.logging.Log;
import java.lang.ref.WeakReference;
import java.util.TimerTask;

public class MHousekeeper {
    private static Log log = Log.getLog(MHousekeeper.class);
    private MTimer timer;

    public MHousekeeper() {
        log.t("new housekeeper");
        this.timer = new MTimer(true);
    }

    public void register(MHousekeeperTask task, long sleep, boolean weak) {
        this.timer.schedule((TimerTask)new MyTimerTask(task, weak), sleep, sleep);
    }

    public void finalize() {
        log.t("finalize");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    public static Log log() {
        return log;
    }

    private class MyTimerTask
    extends MTimerTask {
        private WeakReference<TimerTask> refWeak;
        private TimerTask ref;

        public MyTimerTask(TimerTask task, boolean weak) {
            if (weak) {
                this.refWeak = new WeakReference<TimerTask>(task);
            } else {
                this.ref = task;
            }
        }

        @Override
        public void doit() throws Exception {
            TimerTask r = null;
            r = this.refWeak != null ? (TimerTask)this.refWeak.get() : this.ref;
            if (r == null) {
                this.cancel();
                return;
            }
            r.run();
        }
    }
}

