/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MSingleton;
import de.mhus.lib.MString;
import de.mhus.lib.MThread;
import de.mhus.lib.config.ConfigUtil;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.MConfigFactory;
import de.mhus.lib.logging.Log;
import de.mhus.lib.logging.MLog;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;

public class MFile
extends File {
    private static final long serialVersionUID = -8881575958961356200L;
    private static final String DEFAULT_MIME = "application/octet-stream";
    private static Log log = Log.getLog(MFile.class);
    private static IConfig mimeConfigCache;
    private static IConfig mhuMimeConfigCache;

    public MFile(File parent, String name) {
        super(parent, name);
    }

    public MFile(String arg0, String arg1) {
        super(arg0, arg1);
    }

    public MFile(String path) {
        super(path);
    }

    public MFile(URI uri) {
        super(uri);
    }

    public OutputStream createOutputStream() throws IOException {
        return new FileOutputStream(this);
    }

    public InputStream createInputStream() throws IOException {
        return new FileInputStream(this);
    }

    public static String getFileSuffix(File _file) {
        return MFile.getFileSuffix(_file.getAbsolutePath());
    }

    public static String getFileSuffix(String _name) {
        String name = _name;
        if (!MString.isIndex(name, '.')) {
            return "";
        }
        name = MString.afterLastIndex(name, '.');
        return name;
    }

    public static String getFileName(String _path) {
        String name = _path;
        while (MString.isIndex(name, File.separatorChar)) {
            name = MString.afterIndex(name, File.separatorChar);
        }
        return name;
    }

    public static File getWorkingDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static String readFile(File _f) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream fis;
            InputStream inputStream = fis = _f instanceof MFile ? ((MFile)_f).createInputStream() : new FileInputStream(_f);
            while (fis.available() != 0) {
                sb.append((char)fis.read());
            }
            fis.close();
        }
        catch (Exception e) {
            log.debug("" + _f, e);
        }
        return sb.toString();
    }

    public static String readFile(Reader _is) {
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            while (true) {
                int size;
                if ((size = _is.read(buffer)) < 0) {
                    return sb.toString();
                }
                if (size <= 0) continue;
                sb.append(buffer, 0, size);
            }
        }
        catch (EOFException eofe) {
        }
        catch (Exception e) {
            log.debug(e);
        }
        return sb.toString();
    }

    public static String readUTF8(InputStream _is) throws IOException {
        return MFile.readUCF(_is, Charset.forName("utf-8"));
    }

    public static String readUCF(InputStream _is, Charset charset) throws IOException {
        byte[] buffer = MFile.readBinary(_is);
        return new String(buffer, charset);
    }

    public static String readFile(InputStream _is) {
        StringBuffer sb = new StringBuffer();
        try {
            int ret;
            while ((ret = _is.read()) >= 0) {
                sb.append((char)ret);
            }
        }
        catch (EOFException eofe) {
        }
        catch (Exception e) {
            log.debug(e);
        }
        return sb.toString();
    }

    public static byte[] readBinaryFile(File in) throws IOException {
        InputStream fis = in instanceof MFile ? ((MFile)in).createInputStream() : new FileInputStream(in);
        int size = (int)in.length();
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = (byte)fis.read();
        }
        return buffer;
    }

    public static byte[] readBinary(InputStream is) throws IOException {
        return MFile.readBinary(is, false);
    }

    public static byte[] readBinary(InputStream is, boolean close) throws IOException {
        int j;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((j = is.read(buffer, 0, buffer.length)) >= 0) {
            i += j;
            stream.write(buffer, 0, j);
        }
        if (close) {
            is.close();
        }
        return stream.toByteArray();
    }

    public static void readBinary(InputStream is, byte[] buffer, int offset, int length) throws IOException {
        int j;
        do {
            if ((j = is.read(buffer, offset, length)) < 0) {
                throw new EOFException();
            }
            if (j == 0) {
                MThread.sleep(10L);
            }
            offset += j;
        } while ((length -= j) > 0);
    }

    public static boolean writeFile(File _f, String _content) {
        try {
            OutputStream fos = _f instanceof MFile ? ((MFile)_f).createOutputStream() : new FileOutputStream(_f);
            char[] c = _content.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                fos.write(c[i]);
            }
            fos.close();
        }
        catch (Exception e) {
            log.debug("" + _f, e);
            return false;
        }
        return true;
    }

    public static boolean writeFile(File _f, byte[] _content) {
        try {
            OutputStream fos = _f instanceof MFile ? ((MFile)_f).createOutputStream() : new FileOutputStream(_f);
            MFile.writeFile(fos, _content, 0, _content.length);
            fos.close();
        }
        catch (Exception e) {
            log.debug("" + _f, e);
            return false;
        }
        return true;
    }

    public static void writeFile(OutputStream fos, byte[] _content, int offset, int length) throws IOException {
        fos.write(_content, offset, length);
    }

    public static boolean copyFile(File _src, File _dest) {
        if (_src.isDirectory()) {
            return false;
        }
        try {
            InputStream fis = _src instanceof MFile ? ((MFile)_src).createInputStream() : new FileInputStream(_src);
            OutputStream fos = _dest instanceof MFile ? ((MFile)_dest).createOutputStream() : new FileOutputStream(_dest);
            MFile.copyFile(fis, fos);
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            log.debug("" + _src + " -> " + _dest, e);
            return false;
        }
        return true;
    }

    public static void copyFile(InputStream _is, OutputStream _os) {
        long free = Runtime.getRuntime().freeMemory();
        if (free < 1024L) {
            free = 1024L;
        }
        if (free > 32768L) {
            free = 32768L;
        }
        byte[] buffer = new byte[(int)free];
        int i = 0;
        try {
            while ((i = _is.read(buffer)) != -1) {
                _os.write(buffer, 0, i);
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void copyFile(Reader _is, Writer _os) {
        long free = Runtime.getRuntime().freeMemory();
        if (free < 1024L) {
            free = 1024L;
        }
        if (free > 32768L) {
            free = 32768L;
        }
        char[] buffer = new char[(int)free / 2];
        int i = 0;
        try {
            while ((i = _is.read(buffer)) != -1) {
                _os.write(buffer, 0, i);
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static String toFileName(String _name) {
        String out = _name.replace('\\', '_');
        out = out.replace('/', '_');
        out = out.replace('*', '_');
        out = out.replace('?', '_');
        out = out.replace('+', '_');
        out = out.replace('#', '_');
        out = out.replace('\'', '_');
        out = out.replace('\"', '_');
        out = out.replace('$', '_');
        out = out.replace('%', '_');
        out = out.replace('?', '_');
        out = out.replace(':', '_');
        out = out.replace('<', '_');
        out = out.replace('>', '_');
        out = out.replace('{', '_');
        out = out.replace('}', '_');
        return out;
    }

    public static void deleteDir(File _dir) {
        if (!_dir.isDirectory()) {
            _dir.delete();
            return;
        }
        File[] list = _dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            MFile.deleteDir(list[i]);
        }
        _dir.delete();
    }

    public static void copyDir(File _src, File _dest) {
        MFile.copyDir(_src, _dest, (String)null);
    }

    public static void copyDir(File _src, File _dest, String _filter) {
        if (_filter == null) {
            MFile.copyDir(_src, _dest, (FileFilter)null);
        } else {
            MFile.copyDir(_src, _dest, MString.split(_filter, ","));
        }
    }

    public static void copyDir(File _src, File _dest, final String[] _filter) {
        if (_filter == null) {
            MFile.copyDir(_src, _dest, (FileFilter)null);
        } else {
            MFile.copyDir(_src, _dest, new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    for (int i = 0; i < _filter.length; ++i) {
                        if (_filter[i] == null || !_filter[i].equals(arg0.getName())) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    public static void copyDir(File _src, File _dest, FileFilter _filter) {
        if (_filter != null && !_filter.accept(_src)) {
            return;
        }
        if (!_src.isDirectory()) {
            MFile.copyFile(_src, _dest);
            return;
        }
        try {
            _dest.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        File[] list = _src.listFiles();
        for (int i = 0; i < list.length; ++i) {
            MFile.copyDir(list[i], new File(_dest, list[i].getName()), _filter);
        }
    }

    public static String normalize(String name) {
        if (name.indexOf(92) >= 0) {
            name = name.replaceAll("\\\\", "_");
        }
        if (name.indexOf(47) >= 0) {
            name = name.replaceAll("/", "_");
        }
        if (name.indexOf(42) >= 0) {
            name = name.replaceAll("\\*", "_");
        }
        if (name.indexOf(63) >= 0) {
            name = name.replaceAll("\\?", "_");
        }
        if (name.indexOf(58) >= 0) {
            name = name.replaceAll(":", "_");
        }
        if (name.indexOf(32) >= 0) {
            name = name.replaceAll(" ", "_");
        }
        return name;
    }

    public static String getFileNameOnly(String key) {
        if (key == null) {
            return null;
        }
        if (key.indexOf(47) >= 0) {
            key = MString.afterLastIndex(key, '/');
        }
        if (key.indexOf(92) >= 0) {
            key = MString.afterLastIndex(key, '\\');
        }
        if (key.length() > 1 && key.indexOf(46, 1) >= 0) {
            key = MString.beforeLastIndex(key, '.');
        }
        return key;
    }

    public static String replaceExtension(String name, String newExtension) {
        if (name == null || newExtension == null) {
            return name;
        }
        return MString.beforeLastIndex(name, '.') + "." + newExtension;
    }

    public static String getMimeType(String extension) {
        String file;
        IConfig map;
        if (extension == null) {
            return null;
        }
        extension = extension.trim().toLowerCase();
        String mime = null;
        IConfig config = MSingleton.instance().getConfig(MFile.class, null);
        if (config != null && (map = config.getConfig("mapping")) != null) {
            mime = map.getExtracted(extension);
        }
        if (mime == null && config != null && (file = config.getExtracted("file")) != null) {
            if (mimeConfigCache == null) {
                try {
                    mimeConfigCache = MConfigFactory.getInstance().createConfigFor(new File(file));
                }
                catch (Exception e) {
                    MLog.w(file, e);
                }
            }
            if (mimeConfigCache != null && (mime = mimeConfigCache.getExtracted(extension)) == null) {
                mime = mimeConfigCache.getExtracted("default");
            }
        }
        if (mime == null) {
            if (mhuMimeConfigCache == null) {
                try {
                    mhuMimeConfigCache = ConfigUtil.loadPropertiesForClass(MFile.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (mhuMimeConfigCache != null && (mime = mhuMimeConfigCache.getExtracted(extension)) == null) {
                mime = mhuMimeConfigCache.getExtracted("default");
            }
        }
        if (mime == null) {
            mime = DEFAULT_MIME;
        }
        return mime;
    }
}

