/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MCast;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class MDate {
    private long time = 0L;
    private TimeZone tz;

    public MDate(long time, TimeZone tz) {
        this.time = time;
        this.tz = tz;
    }

    public MDate() {
        this(null);
    }

    public MDate(Object value) {
        if (value == null) {
            this.time = System.currentTimeMillis();
            this.tz = TimeZone.getDefault();
        } else if (value instanceof Calendar) {
            Calendar date = (Calendar)value;
            this.time = date.getTimeInMillis();
            this.tz = date.getTimeZone();
        } else if (value instanceof Date) {
            Date date = (Date)value;
            this.time = date.getTime();
            this.tz = TimeZone.getDefault();
        } else if (value instanceof MDate) {
            MDate date = (MDate)value;
            this.time = date.getTime();
            this.tz = date.getTimeZone();
        } else if (value instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)value;
            this.time = date.getTime();
            this.tz = TimeZone.getDefault();
        } else {
            String dateString = value.toString();
            Date date = MCast.toDate(dateString, null);
            if (date == null) {
                throw new NumberFormatException(dateString);
            }
            this.time = date.getTime();
            this.tz = TimeZone.getDefault();
        }
    }

    public long getTime() {
        return this.time;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public Date toDate() {
        return new Date(this.time);
    }

    public Calendar toCalendar() {
        Calendar out = Calendar.getInstance(this.tz);
        out.setTimeInMillis(this.time);
        return out;
    }

    public String toString() {
        return MCast.toString(this.toDate());
    }

    public java.sql.Date toSqlDate() {
        return new java.sql.Date(this.time);
    }
}

