/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MCast;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.jmx.MJmx;
import de.mhus.lib.persistence.RoundRobin;
import java.io.File;

@JmxManaged(descrition="Simple Counter")
public class MCount
extends MJmx {
    private long cnt = 0L;
    private String name;
    private long startTime = 0L;
    private long lastTime = 0L;
    private RoundRobin rrd;
    private boolean isClosed;

    public MCount() {
        this.name = "Counter " + MSingleton.instance().nextUniqueId();
        this.persistence();
    }

    public MCount(String name) {
        this.name = name;
        this.persistence();
    }

    private void persistence() {
        try {
            if (MSingleton.instance().isPersistence()) {
                File f = MSingleton.instance().getPersistenceManager().sessionScope().getPersistenceFile(this.getJmxName() + "_" + this.name + ".rrd");
                this.rrd = new RoundRobin(3600000L, f);
            }
        }
        catch (Throwable t) {
            this.log().t(t);
        }
    }

    @JmxManaged(descrition="Reset the counter statistic")
    public void reset() {
        this.isClosed = false;
        this.cnt = 0L;
        this.startTime = 0L;
        this.lastTime = 0L;
    }

    public void inc() {
        if (this.isClosed) {
            return;
        }
        ++this.cnt;
        this.lastTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.lastTime;
        }
        if (this.rrd != null) {
            try {
                this.rrd.add(this.cnt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @JmxManaged(descrition="Amount of counts")
    public long getValue() {
        return this.cnt;
    }

    public double getHitsPerSecond() {
        if (this.startTime == 0L || this.lastTime == 0L || this.cnt == 0L) {
            return 0.0;
        }
        return (double)this.cnt / (double)((this.lastTime - this.startTime) / 1000L);
    }

    @JmxManaged(descrition="Name of this value")
    public String getName() {
        return this.name;
    }

    public long getFirstHitTime() {
        return this.startTime;
    }

    public long getLastHitTime() {
        return this.lastTime;
    }

    @JmxManaged(descrition="Readable status of the counter")
    public String getStatusAsString() {
        if (this.startTime == 0L || this.lastTime == 0L || this.cnt == 0L) {
            return "unused";
        }
        return MCast.toIsoDateTime(this.getFirstHitTime()) + " - " + MCast.toIsoDateTime(this.getLastHitTime()) + "," + this.getHitsPerSecond() + " hits/sec," + this.cnt;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.log().i("close", this.name, this.cnt, this.getHitsPerSecond());
        try {
            if (MSingleton.instance().isPersistence()) {
                IConfig persistence = MSingleton.instance().getPersistenceManager().sessionScope().getPersistence("de.mhus.lib");
                long uid = MSingleton.instance().nextUniqueId();
                persistence.setString(this.getJmxName() + "_" + this.name + "_" + uid, this.getStatusAsString());
                if (this.rrd != null) {
                    persistence.setString(this.getJmxName() + "_" + this.name + "_rrd_" + uid, this.rrd.dump());
                }
                persistence.save();
            }
        }
        catch (Throwable t) {
            this.log().t(t);
        }
    }

    protected void finalize() {
        this.close();
    }

    public String toString() {
        return this.name + "=" + this.getStatusAsString() + "@MCount";
    }
}

