/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.MException;
import de.mhus.lib.logging.MLog;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class IProperties
implements Iterable<Map.Entry<String, Object>> {
    public abstract Object getProperty(String var1);

    @Deprecated
    public int getProperty(String name, int def) {
        return this.getInt(name, def);
    }

    @Deprecated
    public boolean getProperty(String name, boolean def) {
        return this.getBoolean(name, def);
    }

    @Deprecated
    public String getProperty(String name, String def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        return String.valueOf(out);
    }

    public String getString(String name, String def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        return String.valueOf(out);
    }

    public boolean getBoolean(String name, boolean def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Boolean) {
            return (Boolean)out;
        }
        return MCast.toboolean(String.valueOf(out), def);
    }

    public int getInt(String name, int def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).intValue();
        }
        return MCast.toint(String.valueOf(out), def);
    }

    public long getLong(String name, long def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).longValue();
        }
        return MCast.tolong(String.valueOf(out), def);
    }

    public float getFloat(String name, float def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).floatValue();
        }
        return MCast.tofloat(String.valueOf(out), def);
    }

    public double getDouble(String name, double def) {
        Object out = this.getProperty(name);
        if (out == null) {
            return def;
        }
        if (out instanceof Number) {
            return ((Number)out).doubleValue();
        }
        return MCast.todouble(String.valueOf(out), def);
    }

    public Calendar getCalendar(String name) {
        Object out = this.getProperty(name);
        if (out == null) {
            return null;
        }
        if (out instanceof Calendar) {
            return (Calendar)out;
        }
        return MCast.toCalendar(String.valueOf(out));
    }

    public MDate getDate(String name) {
        try {
            return new MDate(this.getProperty(name));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setString(String name, String value) throws MException {
        this.setProperty(name, value);
    }

    public void setInt(String name, int value) throws MException {
        this.setProperty(name, value);
    }

    public void setLong(String name, long value) throws MException {
        this.setProperty(name, value);
    }

    public void setDouble(String name, double value) throws MException {
        this.setProperty(name, value);
    }

    public void setFloat(String name, float value) throws MException {
        this.setProperty(name, Float.valueOf(value));
    }

    public void setBoolean(String name, boolean value) throws MException {
        this.setProperty(name, value);
    }

    public void setCalendar(String name, Calendar value) throws MException {
        this.setProperty(name, value);
    }

    public void setDate(String name, MDate value) throws MException {
        this.setProperty(name, value);
    }

    public abstract boolean isProperty(String var1);

    public abstract void removeProperty(String var1) throws MException;

    public abstract void setProperty(String var1, Object var2) throws MException;

    public abstract boolean isEditable();

    public abstract Set<String> keys();

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new IPIterator();
    }

    private class IPEntry
    implements Map.Entry<String, Object> {
        private String key;

        public IPEntry(String next) {
            this.key = next;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return IProperties.this.getProperty(this.key);
        }

        @Override
        public Object setValue(Object value) {
            Object old = IProperties.this.getProperty(this.key);
            try {
                IProperties.this.setProperty(this.key, value);
            }
            catch (MException e) {
                MLog.t(e);
            }
            return old;
        }
    }

    private class IPIterator
    implements Iterator<Map.Entry<String, Object>> {
        private Iterator<String> keys;
        private String currentkey;

        IPIterator() {
            this.keys = IProperties.this.keys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.currentkey = this.keys.next();
            return new IPEntry(this.currentkey);
        }

        @Override
        public void remove() {
            try {
                IProperties.this.removeProperty(this.currentkey);
            }
            catch (MException e) {
                MLog.t(e);
            }
        }
    }
}

