/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.ui;

import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.TextField;

public class SpinnerNumberField<T>
extends TextField {
    private static final long serialVersionUID = 1L;
    private boolean allowNegative;
    private long max;
    private long min;
    private boolean allowNull;
    private Class<? extends Number> numberClass;
    private SpinnerValidator validator;
    private boolean maxSet;
    private boolean minSet;

    public SpinnerNumberField(Class<? extends Number> numberClass) {
        this.numberClass = numberClass;
        this.validator = new SpinnerValidator("Insert a valid number.");
        this.addValidator((Validator)this.validator);
    }

    public void setAllowNegative(boolean boolean1) {
        this.allowNegative = boolean1;
    }

    public void setAllowNull(boolean boolean1) {
        this.allowNull = boolean1;
    }

    public void setMaxVal(long long1) {
        this.max = long1;
        this.maxSet = true;
    }

    public void setMinVal(long long1) {
        this.min = long1;
        this.minSet = true;
    }

    public Number getNumberValue() {
        return this.getNumberValue(String.valueOf(this.getValue()));
    }

    protected Number getNumberValue(String value) {
        if (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        Number n = null;
        n = this.numberClass == Double.class ? (Number)Double.parseDouble(value) : (Number)(this.numberClass == Float.class ? (Number)Float.valueOf(Float.parseFloat(value)) : (Number)(this.numberClass == Long.class ? (Number)Long.parseLong(value) : (Number)Integer.parseInt(value)));
        return n;
    }

    private class SpinnerValidator
    extends AbstractStringValidator {
        private static final long serialVersionUID = 1L;

        public SpinnerValidator(String errorMessage) {
            super(errorMessage);
        }

        protected boolean isValidValue(String value) {
            if (SpinnerNumberField.this.allowNull && value == null) {
                return true;
            }
            try {
                Number n = SpinnerNumberField.this.getNumberValue(value);
                if (!SpinnerNumberField.this.allowNegative && n.longValue() < 0L) {
                    return false;
                }
                if (SpinnerNumberField.this.minSet && n.longValue() < SpinnerNumberField.this.min) {
                    return false;
                }
                if (SpinnerNumberField.this.maxSet && n.longValue() > SpinnerNumberField.this.max) {
                    return false;
                }
            }
            catch (Throwable e) {
                return false;
            }
            return true;
        }
    }
}

