/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.login;

import com.vaadin.event.ShortcutListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.vaadin.ui.HelpManager;

public class LoginPanel
extends VerticalLayout
implements MNlsProvider {
    private static final long serialVersionUID = 1L;
    private HelpManager helpManager;
    private Listener listener;
    private MNls nls;
    private Label error;

    public LoginPanel() {
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 1L;

            public void attach(ClientConnector.AttachEvent event) {
                LoginPanel.this.doContent();
            }
        });
    }

    protected void doContent() {
        this.helpManager = new HelpManager(this.getUI());
        this.helpManager.closeAll();
        String welcomeTxt = MNls.find((MNlsProvider)this, (String)"login.help.title");
        if (welcomeTxt != null) {
            this.helpManager.showHelp(welcomeTxt, MNls.find((MNlsProvider)this, (String)"login.help.description"), "login");
        }
        this.addStyleName("login");
        LoginPanel loginLayout = this;
        loginLayout.setSizeFull();
        loginLayout.addStyleName("login-layout");
        loginLayout.setWidth("450px");
        VerticalLayout loginPanel = new VerticalLayout();
        loginPanel.addStyleName("login-panel");
        HorizontalLayout labels = new HorizontalLayout();
        labels.setWidth("100%");
        labels.setMargin(true);
        labels.addStyleName("labels");
        loginPanel.addComponent((Component)labels);
        Label welcome = new Label(MNls.find((MNlsProvider)this, (String)"login.welcome=Welcome"));
        welcome.setSizeUndefined();
        welcome.addStyleName("h4");
        labels.addComponent((Component)welcome);
        labels.setComponentAlignment((Component)welcome, Alignment.MIDDLE_LEFT);
        Label title = new Label(MNls.find((MNlsProvider)this, (String)"login.title="));
        title.setSizeUndefined();
        title.addStyleName("h2");
        title.addStyleName("light");
        labels.addComponent((Component)title);
        labels.setComponentAlignment((Component)title, Alignment.MIDDLE_RIGHT);
        HorizontalLayout fields = new HorizontalLayout();
        fields.setSpacing(true);
        fields.setMargin(true);
        fields.addStyleName("fields");
        final TextField username = new TextField(MNls.find((MNlsProvider)this, (String)"login.username=Username"));
        username.focus();
        fields.addComponent((Component)username);
        final PasswordField password = new PasswordField(MNls.find((MNlsProvider)this, (String)"login.password=Password"));
        fields.addComponent((Component)password);
        final Button signin = new Button(MNls.find((MNlsProvider)this, (String)"login.signin=Sign In"));
        signin.addStyleName("default");
        fields.addComponent((Component)signin);
        fields.setComponentAlignment((Component)signin, Alignment.BOTTOM_LEFT);
        this.error = new Label("", ContentMode.HTML);
        this.error.addStyleName("error");
        this.error.setSizeUndefined();
        this.error.addStyleName("light");
        this.error.addStyleName("v-animate-reveal");
        loginPanel.addComponent((Component)this.error);
        loginPanel.setComponentAlignment((Component)this.error, Alignment.MIDDLE_CENTER);
        final ShortcutListener enter = new ShortcutListener(MNls.find((MNlsProvider)this, (String)"login.signin=Sign In"), 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                signin.click();
            }
        };
        signin.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if ("".equals(password.getValue())) {
                    password.focus();
                    return;
                }
                LoginPanel.this.error.setCaption("");
                if (LoginPanel.this.listener != null && LoginPanel.this.listener.doLogin(username.getValue(), password.getValue())) {
                    signin.removeShortcutListener(enter);
                } else {
                    LoginPanel.this.error.setCaption(MNls.find((MNlsProvider)LoginPanel.this, (String)"login.error=Wrong username or password."));
                    username.focus();
                }
            }
        });
        signin.addShortcutListener(enter);
        loginPanel.addComponent((Component)fields);
        loginLayout.addComponent((Component)loginPanel);
        loginLayout.setComponentAlignment((Component)loginPanel, Alignment.MIDDLE_CENTER);
        this.doCustomize(loginPanel, labels, fields);
    }

    protected void doCustomize(VerticalLayout loginPanel, HorizontalLayout labels, HorizontalLayout fields) {
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public MNls getNls() {
        return this.nls;
    }

    public void setNls(MNls nls) {
        this.nls = nls;
    }

    public static interface Listener {
        public boolean doLogin(String var1, String var2);
    }
}

