/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.layouter;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.Layout;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.errors.MException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayUtil {
    private static final Pattern sizePattern = Pattern.compile("^(-?\\d+(\\.\\d+)?)(%|px|em|ex|in|cm|mm|pt|pc)?$");

    public static void configure(AbstractComponent layout, ResourceNode<?> config) throws MException {
        if (config.getBoolean("full_size", false)) {
            layout.setSizeFull();
        } else {
            String height;
            String width = config.getString("width", null);
            if (width != null) {
                layout.setWidth(width);
            }
            if ((height = config.getString("height", null)) != null) {
                layout.setHeight(height);
            }
        }
        if (layout instanceof Layout.SpacingHandler && config.isProperty("spacing")) {
            ((Layout.SpacingHandler)layout).setSpacing(config.getBoolean("spacing", false));
        }
        if (config.isProperty("style")) {
            layout.setStyleName(config.getExtracted("style"));
        }
        if (config.getBoolean("hidden", false)) {
            layout.setVisible(false);
        }
        if (layout instanceof AbstractSplitPanel) {
            float[] s;
            String a = config.getString("split_min", null);
            if (a != null && (s = LayUtil.parseStringSize(a))[0] >= 0.0f) {
                ((AbstractSplitPanel)layout).setMinSplitPosition(s[0], Sizeable.Unit.values()[(int)s[1]]);
            }
            if ((a = config.getString("split_max", null)) != null && (s = LayUtil.parseStringSize(a))[0] >= 0.0f) {
                ((AbstractSplitPanel)layout).setMaxSplitPosition(s[0], Sizeable.Unit.values()[(int)s[1]]);
            }
            if ((a = config.getString("split_pos", null)) != null && (s = LayUtil.parseStringSize(a))[0] >= 0.0f) {
                ((AbstractSplitPanel)layout).setSplitPosition(s[0], Sizeable.Unit.values()[(int)s[1]]);
            }
        }
    }

    public static float[] parseStringSize(String s) {
        float[] values = new float[]{-1.0f, Sizeable.Unit.PIXELS.ordinal()};
        if (s == null) {
            return values;
        }
        if ("".equals(s = s.trim())) {
            return values;
        }
        Matcher matcher = sizePattern.matcher(s);
        if (matcher.find()) {
            values[0] = Float.parseFloat(matcher.group(1));
            if (values[0] < 0.0f) {
                values[0] = -1.0f;
            } else {
                String unit = matcher.group(3);
                if (unit == null) {
                    values[1] = Sizeable.Unit.PIXELS.ordinal();
                } else if (unit.equals("px")) {
                    values[1] = Sizeable.Unit.PIXELS.ordinal();
                } else if (unit.equals("%")) {
                    values[1] = Sizeable.Unit.PERCENTAGE.ordinal();
                } else if (unit.equals("em")) {
                    values[1] = Sizeable.Unit.EM.ordinal();
                } else if (unit.equals("ex")) {
                    values[1] = Sizeable.Unit.EX.ordinal();
                } else if (unit.equals("in")) {
                    values[1] = Sizeable.Unit.INCH.ordinal();
                } else if (unit.equals("cm")) {
                    values[1] = Sizeable.Unit.CM.ordinal();
                } else if (unit.equals("mm")) {
                    values[1] = Sizeable.Unit.MM.ordinal();
                } else if (unit.equals("pt")) {
                    values[1] = Sizeable.Unit.POINTS.ordinal();
                } else if (unit.equals("pc")) {
                    values[1] = Sizeable.Unit.PICAS.ordinal();
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid size argument: \"" + s + "\" (should match " + sizePattern.pattern() + ")");
        }
        return values;
    }
}

