/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import com.vaadin.v7.ui.TwinColSelect;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.Item;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiVaadin;
import java.util.Set;
import java.util.TreeSet;

public class UiOptions
extends UiVaadin {
    @Override
    public Component createEditor() {
        TwinColSelect ret = new TwinColSelect();
        ret.setMultiSelect(true);
        ret.setNullSelectionAllowed(true);
        ret.setLeftColumnCaption(MNls.find((MNlsProvider)this.getForm(), (String)(this.getName() + ".available=Available options")));
        ret.setRightColumnCaption(MNls.find((MNlsProvider)this.getForm(), (String)(this.getName() + ".selected=Selected options")));
        return ret;
    }

    @Override
    protected void setValue(Object value) throws MException {
        if (value == null) {
            ((TwinColSelect)this.getComponentEditor()).setValue(new TreeSet());
            return;
        }
        if (!(value instanceof Set)) {
            value = MCollection.toTreeSet((Object[])String.valueOf(value).split(","));
        }
        ((TwinColSelect)this.getComponentEditor()).setValue(value);
    }

    @Override
    protected Object getValue() throws MException {
        Set ret = (Set)((TwinColSelect)this.getComponentEditor()).getValue();
        if (ret == null) {
            return null;
        }
        return ret;
    }

    @Override
    public void doUpdateMetadata() throws MException {
        TwinColSelect cb = (TwinColSelect)this.getComponentEditor();
        cb.removeAllItems();
        String itemsName = this.getConfig().getString("itemdef", this.getName() + ".items");
        Item[] items = (Item[])this.getForm().getDataSource().getObject(itemsName, null);
        if (items != null) {
            for (Item item : items) {
                cb.addItem((Object)item);
            }
        }
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiOptions();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

