/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.form.UiWizard;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;

public class UiLayout100
extends UiLayout {
    private static final long serialVersionUID = 1L;
    private GridLayout layout = new GridLayout(3, 1);
    private int rows;

    public UiLayout100() {
        this.layout.setMargin(true);
        this.layout.setSpacing(true);
        this.layout.setHideEmptyRowsAndColumns(true);
        this.layout.setColumnExpandRatio(0, 0.3f);
        this.layout.setColumnExpandRatio(1, 0.7f);
        this.layout.setColumnExpandRatio(2, 0.0f);
        this.layout.setWidth("100%");
        this.rows = 0;
    }

    @Override
    public void createRow(final UiVaadin c) {
        Label l;
        UiRow row1;
        final UiWizard wizard = c.getWizard();
        Component e = c.createEditor();
        if (e == null) {
            return;
        }
        e.setWidth("100%");
        c.setComponentEditor(e);
        c.setListeners();
        if (c.isFullSize()) {
            row1 = this.createRow();
            row1.setFull(true);
            l = new Label();
            l.setWidth("100%");
            c.setComponentLabel((Component)l);
            row1.setComponent((Component)l);
            UiRow row2 = this.createRow();
            row2.setFull(true);
            if (wizard != null) {
                Button b = new Button("W");
                b.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        wizard.showWizard((UiComponent)c);
                    }
                });
                b.setWidth("100%");
                row2.setWizard((Component)b);
                c.setComponentWizard((Component)b);
            }
            row2.setComponent(e);
        } else {
            row1 = this.createRow();
            l = new Label();
            l.setWidth("100%");
            c.setComponentLabel((Component)l);
            row1.setLeft((Component)l);
            if (wizard != null) {
                Button b = new Button("W");
                b.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        wizard.showWizard((UiComponent)c);
                    }
                });
                b.setWidth("100%");
                row1.setWizard((Component)b);
                c.setComponentWizard((Component)b);
            }
            row1.setRight(e);
        }
        UiRow row3 = this.createRow();
        row3.setFull(c.isFullSize());
        Label le = new Label();
        le.setStyleName("error-text");
        le.setWidth("100%");
        c.setComponentError((Component)le);
        row3.setComponent((Component)le);
    }

    protected UiRow createRow() {
        ++this.rows;
        this.layout.setRows(this.rows);
        return new UiRow(this.layout, this.rows - 1);
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiLayout100();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }

    public class UiRow {
        private GridLayout layout;
        private int row;
        private boolean full;
        private boolean wizard;

        public UiRow(GridLayout layout, int row) {
            this.layout = layout;
            this.row = row;
        }

        public void setLeft(Component component) {
            if (this.full) {
                return;
            }
            this.layout.addComponent(component, 0, this.row);
        }

        public void setRight(Component component) {
            if (this.full) {
                return;
            }
            if (this.wizard) {
                this.layout.addComponent(component, 1, this.row);
            } else {
                this.layout.addComponent(component, 1, this.row, 2, this.row);
            }
        }

        public void setComponent(Component component) {
            if (!this.full) {
                this.setRight(component);
                return;
            }
            if (this.wizard) {
                this.layout.addComponent(component, 0, this.row, 1, this.row);
            } else {
                this.layout.addComponent(component, 0, this.row, 2, this.row);
            }
        }

        public boolean isFull() {
            return this.full;
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public boolean isWizard() {
            return this.wizard;
        }

        public void setWizard(Component wizard) {
            boolean bl = this.wizard = wizard != null;
            if (wizard == null) {
                return;
            }
            this.layout.addComponent(wizard, 2, this.row);
        }
    }
}

