/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.shared.ui.datefield.DateResolution;
import com.vaadin.shared.ui.datefield.DateTimeResolution;
import com.vaadin.ui.AbstractDateField;
import com.vaadin.ui.Component;
import com.vaadin.ui.DateField;
import com.vaadin.ui.DateTimeField;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.form.definition.FmDate;
import de.mhus.lib.vaadin.form.UiVaadin;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Date;

public class UiDate
extends UiVaadin {
    ZoneId zoneId = ZoneId.systemDefault();

    @Override
    protected void setValue(Object value) throws MException {
        Date date = MCast.toDate((Object)value, null);
        Component field = this.getComponentEditor();
        if (date == null) {
            ((AbstractDateField)field).setValue(null);
        } else if (field instanceof DateField) {
            LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(this.zoneId).toLocalDate();
            ((DateField)field).setValue((Temporal)localDate);
        } else if (field instanceof DateTimeField) {
            LocalDateTime localDate = Instant.ofEpochMilli(date.getTime()).atZone(this.zoneId).toLocalDateTime();
            ((DateTimeField)field).setValue((Temporal)localDate);
        }
    }

    @Override
    public Component createEditor() {
        DateField ret = null;
        FmDate.FORMATS format = FmDate.FORMATS.valueOf((String)this.getConfig().getString("format", FmDate.FORMATS.DATE.name()).toUpperCase());
        switch (format) {
            case DATE: {
                ret = new DateField();
                ret.setResolution((Enum)DateResolution.DAY);
                break;
            }
            case DATETIME: {
                ret = new DateTimeField();
                ((DateTimeField)ret).setResolution((Enum)DateTimeResolution.MINUTE);
                break;
            }
            case DATETIMESECONDS: {
                ret = new DateTimeField();
                ((DateTimeField)ret).setResolution((Enum)DateTimeResolution.SECOND);
                break;
            }
            case TIME: {
                ret = new DateTimeField();
                ((DateTimeField)ret).setDateFormat("HH:mm");
                ((DateTimeField)ret).setResolution((Enum)DateTimeResolution.MINUTE);
                break;
            }
            case TIMESECONDS: {
                ret = new DateTimeField();
                ret.setDateFormat("HH:mm:ss");
                ((DateTimeField)ret).setResolution((Enum)DateTimeResolution.SECOND);
                break;
            }
            case CUSTOM: {
                ret = new DateTimeField();
                String custom = this.getConfig().getString("customformat", null);
                if (custom != null) {
                    ret.setDateFormat(custom);
                }
                ((DateTimeField)ret).setResolution((Enum)DateTimeResolution.SECOND);
                break;
            }
            default: {
                ret = new DateField();
            }
        }
        ret.setLocale(this.getForm().getLocale());
        return ret;
    }

    @Override
    protected Object getValue() throws MException {
        Component field = this.getComponentEditor();
        if (field instanceof DateField) {
            LocalDate localDate = (LocalDate)((DateField)field).getValue();
            return Date.from(localDate.atStartOfDay(this.zoneId).toInstant());
        }
        if (field instanceof DateTimeField) {
            LocalDateTime localDate = (LocalDateTime)((DateTimeField)field).getValue();
            return Date.from(localDate.atZone(this.zoneId).toInstant());
        }
        return null;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiDate();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

