/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import com.vaadin.v7.ui.ComboBox;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.Item;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiVaadin;

public class UiCombobox
extends UiVaadin {
    @Override
    public Component createEditor() {
        ComboBox ret = new ComboBox();
        ret.setNullSelectionAllowed(false);
        ret.setTextInputAllowed(false);
        return ret;
    }

    @Override
    protected void setValue(Object value) throws MException {
        ((ComboBox)this.getComponentEditor()).setValue((Object)MCast.toString((Object)value));
    }

    @Override
    protected Object getValue() throws MException {
        String ret = (String)((ComboBox)this.getComponentEditor()).getValue();
        if (ret == null) {
            return null;
        }
        return ret;
    }

    @Override
    public void doUpdateMetadata() throws MException {
        ComboBox cb = (ComboBox)this.getComponentEditor();
        Object value = cb.getValue();
        cb.removeAllItems();
        String itemsDef = this.getConfig().getString("itemdef", this.getName() + ".items");
        Object itemsObj = this.getForm().getDataSource().getObject(itemsDef, null);
        if (itemsObj == null) {
            itemsObj = this.getConfig().getString("items", null);
        }
        if (itemsObj != null) {
            if (itemsObj instanceof Item[]) {
                Item[] items;
                for (Item item : items = (Item[])itemsObj) {
                    cb.addItem((Object)item.getKey());
                    cb.setItemCaption((Object)item.getKey(), item.getCaption());
                }
            } else if (itemsObj instanceof String) {
                for (String item : ((String)itemsObj).split(";")) {
                    String[] parts = item.split("=", 2);
                    if (parts.length == 2) {
                        cb.addItem((Object)parts[0]);
                        cb.setItemCaption((Object)parts[0], parts[1]);
                        continue;
                    }
                    if (parts.length != 1) continue;
                    cb.addItem((Object)parts[0]);
                    cb.setItemCaption((Object)parts[0], parts[0]);
                }
            }
        }
        cb.setValue(value);
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiCombobox();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

