/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.desktop;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.Pair;
import de.mhus.lib.vaadin.desktop.HelpContext;
import java.util.List;
import java.util.Locale;

public class NlsHelpContext
extends MLog
implements HelpContext {
    private MNls nls;
    private NlsHelpPanel panel;

    public NlsHelpContext(Object owner, Locale locale) {
        this(MNls.lookup((Object)owner));
    }

    public NlsHelpContext(MNls nls) {
        this.nls = nls;
    }

    @Override
    public synchronized Component getComponent() {
        if (this.panel == null) {
            this.panel = new NlsHelpPanel();
            this.showHelpTopic(null);
        }
        return this.panel;
    }

    @Override
    public void showHelpTopic(String topic) {
        String txt = null;
        txt = topic == null ? MNls.find((MNls)this.nls, (String)"help.main") : MNls.find((MNls)this.nls, (String)("help." + topic));
        if (txt != null) {
            this.getComponent();
            this.panel.setContent(txt);
        }
    }

    @Override
    public List<Pair<String, String>> searchTopics(String search) {
        return null;
    }

    @Override
    public List<Pair<String, String>> getIndex() {
        return null;
    }

    private class NlsHelpPanel
    extends VerticalLayout {
        private static final long serialVersionUID = 1L;
        private Label text = new Label();

        public NlsHelpPanel() {
            this.text.setCaptionAsHtml(true);
            this.addComponent((Component)this.text);
            this.text.setSizeFull();
            this.setSizeFull();
        }

        public void setContent(String txt) {
            this.text.setValue(txt);
        }
    }
}

