/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.desktop;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.vaadin.desktop.GuiApi;
import de.mhus.lib.vaadin.desktop.GuiLifecycle;
import de.mhus.lib.vaadin.desktop.GuiSpaceService;
import de.mhus.lib.vaadin.desktop.HelpContext;
import de.mhus.lib.vaadin.desktop.Navigable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeMap;

public class Desktop
extends CssLayout
implements MNlsProvider {
    private static final long serialVersionUID = 1L;
    private MenuBar menuBar;
    private MenuBar.MenuItem menuSpaces;
    private HorizontalLayout contentScreen;
    private MenuBar.MenuItem[] menuSpace = new MenuBar.MenuItem[4];
    private MenuBar.MenuItem menuLeave;
    protected MenuBar.MenuItem menuUser;
    private MenuBar.MenuItem menuLogout;
    protected GuiSpaceService currentSpace;
    private MenuBar.MenuItem menuOverview;
    private CssLayout overView;
    private MenuBar.MenuItem menuHistory;
    private MenuBar.MenuItem menuBack;
    private static Log log = Log.getLog(Desktop.class);
    private LinkedList<String> history = new LinkedList();
    private TreeMap<String, GuiSpaceService> spaceList = new TreeMap();
    private HashMap<String, AbstractComponent> spaceInstanceList = new HashMap();
    private HashMap<String, HelpContext> helpInstanceList = new HashMap();
    private GuiApi api;
    private MNls nls;
    private int tileWidth = 200;
    private int tileHeight = 160;
    private int tileHorizontalGap = 20;
    private MenuBar.MenuItem menuHelp;
    private boolean helpActive;
    private VerticalLayout helpView;

    public Desktop(GuiApi api) {
        this.api = api;
        this.initGui();
    }

    protected void initGui() {
        this.helpView = new VerticalLayout();
        this.helpView.setSizeFull();
        this.helpView.setStyleName("help-panel");
        this.overView = new CssLayout();
        this.overView.setSizeFull();
        this.overView.setStyleName("overview");
        this.menuBar = new MenuBar();
        this.menuSpaces = this.menuBar.addItem(MNls.find((MNlsProvider)this, (String)"menu.spaces=Spaces"), null);
        this.menuHistory = this.menuBar.addItem(MNls.find((MNlsProvider)this, (String)"menu.history=History"), null);
        this.menuBack = this.menuHistory.addItem(MNls.find((MNlsProvider)this, (String)"menu.back=Back"), new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                Desktop.this.navigateBack();
            }
        });
        this.menuHistory.addSeparator();
        for (int i = 0; i < 15; ++i) {
            this.menuHistory.addItem("", new MenuBar.Command(){
                private static final long serialVersionUID = 1L;

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    String[] parts;
                    String text = selectedItem.getDescription();
                    if (MString.isSet((String)text) && (parts = text.split("\\|", 4)).length == 4) {
                        if (parts[2].equals("null")) {
                            parts[2] = null;
                        }
                        if (parts[3].equals("null")) {
                            parts[3] = null;
                        }
                        Desktop.this.openSpace(parts[1], parts[2], parts[3]);
                    }
                }
            });
        }
        this.menuSpace[0] = this.menuBar.addItem("", null);
        this.menuSpace[1] = this.menuBar.addItem("", null);
        this.menuSpace[2] = this.menuBar.addItem("", null);
        this.menuSpace[3] = this.menuBar.addItem("", null);
        this.menuUser = this.menuBar.addItem("?", null);
        this.menuUser.setStyleName("right");
        this.menuLogout = this.menuUser.addItem(MNls.find((MNlsProvider)this, (String)"menu.logout=Logout"), new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                try {
                    Desktop.this.getApi().getAccessControl().signOut();
                }
                catch (Throwable t) {
                    log.d(new Object[]{t});
                }
                try {
                    UI.getCurrent().close();
                }
                catch (Throwable t) {
                    log.d(new Object[]{t});
                }
                UI.getCurrent().getPage().reload();
            }
        });
        this.menuUser.addSeparator();
        this.menuHelp = this.menuUser.addItem(MNls.find((MNlsProvider)this, (String)"menu.help=Help"), new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                Desktop.this.doShowHelp();
            }
        });
        this.menuHelp.setEnabled(false);
        this.menuUser.addSeparator();
        this.setStyleName("desktop-screen");
        this.menuBar.setStyleName("menubar");
        this.addComponent((Component)this.menuBar);
        this.contentScreen = new HorizontalLayout();
        this.contentScreen.addStyleName("content");
        this.contentScreen.setSizeFull();
        this.addComponent((Component)this.contentScreen);
        this.setSizeFull();
        this.showOverview(false);
    }

    protected void doShowHelp() {
        if (this.currentSpace == null) {
            return;
        }
        if (this.helpActive) {
            this.hideHelp();
            return;
        }
        this.showHelpTopic(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideHelp() {
        Desktop desktop = this;
        synchronized (desktop) {
            if (!this.helpActive) {
                return;
            }
            this.helpView.removeAllComponents();
            this.contentScreen.removeComponent((Component)this.helpView);
            this.helpActive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHelpTopic(String topic) {
        HelpContext help = this.getHelpContext(this.currentSpace.getName());
        if (help == null) {
            this.menuHelp.setEnabled(false);
            return;
        }
        Component component = help.getComponent();
        if (component == null) {
            return;
        }
        Desktop desktop = this;
        synchronized (desktop) {
            if (!this.helpActive) {
                this.contentScreen.addComponent((Component)this.helpView);
                this.contentScreen.setExpandRatio((Component)this.helpView, 0.5f);
            }
            this.helpView.removeAllComponents();
            this.helpView.addComponent(component);
        }
        this.helpActive = true;
    }

    public void refreshSpaceList() {
        String name = "?";
        try {
            name = this.getApi().getAccessControl().getAccount().getDisplayName();
        }
        catch (Throwable t) {
            log.t(new Object[]{t});
        }
        this.menuUser.setText(name == null ? "?" : name);
        this.menuSpaces.removeChildren();
        this.overView.removeAllComponents();
        this.menuOverview = this.menuSpaces.addItem(MNls.find((MNlsProvider)this, (String)"menu.overview=Overview"), new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                Desktop.this.showOverview(true);
            }
        });
        this.menuSpaces.addSeparator();
        LinkedList<GuiSpaceService> componentList = new LinkedList<GuiSpaceService>();
        for (GuiSpaceService space : this.spaceList.values()) {
            try {
                if (space.isHiddenSpace() || !this.hasAccess(space) || !space.hasAccess(this.getApi().getAccessControl())) continue;
                componentList.add(space);
            }
            catch (Throwable t) {
                log.d(new Object[]{space, t});
            }
        }
        Locale locale = null;
        try {
            locale = UI.getCurrent().getPage().getWebBrowser().getLocale();
        }
        catch (Throwable t) {
            log.i(new Object[]{t});
            locale = Locale.getDefault();
        }
        for (final GuiSpaceService space : componentList) {
            int tileSize;
            AbstractComponent tile = space.createTile();
            if (tile == null) {
                NativeButton button = new NativeButton();
                button.setCaptionAsHtml(false);
                button.setCaption(space.getDisplayName(locale));
                button.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = 1L;

                    public void buttonClick(Button.ClickEvent event) {
                        Desktop.this.openSpace(space.getName(), null, null);
                    }
                });
                tile = button;
                tile.addStyleName("cursorhand");
            }
            if ((tileSize = space.getTileSize()) < 1) {
                tileSize = 1;
            }
            if (tileSize > 3) {
                tileSize = 3;
            }
            tile.addStyleName("thumbnail" + tileSize);
            tile.setWidth(this.tileWidth * tileSize + (tileSize - 1) * this.tileHorizontalGap + "px");
            tile.setHeight(this.tileHeight + "px");
            this.overView.addComponent((Component)tile);
            if (space.isHiddenInMenu()) continue;
            MenuBar.MenuItem item = this.menuSpaces.addItem(space.getDisplayName(locale), new MenuBar.Command(){
                private static final long serialVersionUID = 1L;

                public void menuSelected(MenuBar.MenuItem selectedItem) {
                    Desktop.this.openSpace(space.getName(), null, null);
                }
            });
            item.setEnabled(true);
        }
        if (componentList.size() > 0) {
            this.menuSpaces.addSeparator();
        }
        this.menuLeave = this.menuSpaces.addItem(MNls.find((MNlsProvider)this, (String)"menu.leave=Leave Space"), new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                if (Desktop.this.currentSpace == null) {
                    return;
                }
                Desktop.this.removeSpaceComponent(Desktop.this.currentSpace.getName());
                Desktop.this.currentSpace = null;
                Desktop.this.showOverview(true);
            }
        });
        this.menuLeave.setEnabled(false);
    }

    public void removeSpaceComponent(String name) {
        AbstractComponent c = this.spaceInstanceList.remove(name);
        if (c != null && c instanceof GuiLifecycle) {
            ((GuiLifecycle)c).doDestroy();
        }
    }

    protected boolean hasAccess(GuiSpaceService space) {
        return this.getApi().hasAccess(space.getName());
    }

    protected String showSpace(GuiSpaceService space, String subSpace, String search) {
        boolean exists = this.spaceInstanceList.containsKey(space.getName());
        AbstractComponent component = this.getSpaceComponent(space.getName());
        HelpContext help = this.getHelpContext(space.getName());
        this.menuHelp.setEnabled(false);
        this.helpActive = false;
        this.contentScreen.removeAllComponents();
        this.cleanupMenu();
        if (component == null) {
            this.contentScreen.addComponent((Component)new Label(MNls.find((MNlsProvider)this, (String)"spaces.unavailable=Space currently not available") + space.getName()));
            this.addComponent((Component)this.contentScreen);
            return null;
        }
        component.setSizeFull();
        this.contentScreen.addComponent((Component)component);
        this.contentScreen.setExpandRatio((Component)component, 1.0f);
        Locale locale = UI.getCurrent().getPage().getWebBrowser().getLocale();
        this.menuHistory.setText(space.getDisplayName(locale));
        this.menuLeave.setEnabled(true);
        this.currentSpace = space;
        space.createMenu(component, this.menuSpace);
        if (help != null) {
            this.menuHelp.setEnabled(true);
        }
        if (component instanceof Navigable) {
            if (MString.isSet((String)subSpace) || MString.isSet((String)search)) {
                return ((Navigable)component).navigateTo(subSpace, search);
            }
            ((Navigable)component).onShowSpace(!exists);
        }
        return space.getDisplayName(locale);
    }

    protected void showOverview(boolean setLinking) {
        if (this.menuLeave != null) {
            this.menuLeave.setEnabled(false);
        }
        this.contentScreen.removeAllComponents();
        this.cleanupMenu();
        this.currentSpace = null;
        this.contentScreen.addComponent((Component)this.overView);
        this.contentScreen.setExpandRatio((Component)this.overView, 1.0f);
        this.menuHistory.setText(MNls.find((MNlsProvider)this, (String)"menu.history=History"));
        if (setLinking) {
            UI.getCurrent().getPage().setUriFragment("");
        }
    }

    private void cleanupMenu() {
        for (int i = 0; i < this.menuSpace.length; ++i) {
            this.menuSpace[i].removeChildren();
            this.menuSpace[i].setText("");
            this.menuSpace[i].setVisible(false);
        }
    }

    public void doUpdateHistoryMenu() {
        int cnt = -2;
        for (MenuBar.MenuItem c : this.menuHistory.getChildren()) {
            if (cnt >= 0) {
                if (this.history.size() - cnt - 1 < 0) {
                    c.setText("");
                    c.setDescription("");
                    c.setIcon(null);
                } else {
                    String x = this.history.get(this.history.size() - cnt - 1);
                    c.setText(MString.beforeIndex((String)x, (char)'|'));
                    c.setDescription(x);
                    c.setIcon((Resource)VaadinIcons.ARROW_RIGHT);
                }
            }
            ++cnt;
        }
    }

    public void rememberNavigation(String caption, String space, String subSpace, String search, boolean navLink) {
        String newEntry = caption.replace('|', ' ') + "|" + space + "|" + subSpace + "|" + search;
        while (this.history.remove(newEntry)) {
        }
        this.history.add(newEntry);
        this.doUpdateHistoryMenu();
        if (navLink) {
            UI.getCurrent().getPage().setUriFragment("!:" + space + "/" + (subSpace == null ? "" : subSpace) + "/" + (search == null ? "" : search));
        }
    }

    public boolean openSpace(String spaceId, String subSpace, String search) {
        return this.openSpace(spaceId, subSpace, search, true, true);
    }

    public boolean openSpace(String spaceId, String subSpace, String search, boolean history, boolean navLink) {
        GuiSpaceService space = this.getSpace(spaceId);
        if (space == null) {
            return false;
        }
        if (!this.getApi().hasAccess(space.getName()) || !space.hasAccess(this.getApi().getAccessControl())) {
            return false;
        }
        String ret = this.showSpace(space, subSpace, search);
        if (ret != null && history) {
            String newEntry = ret.replace('|', ' ') + "|" + spaceId + "|" + subSpace + "|" + search;
            while (this.history.remove(newEntry)) {
            }
            this.history.add(newEntry);
            this.doUpdateHistoryMenu();
        }
        if (navLink) {
            UI.getCurrent().getPage().setUriFragment("!:" + spaceId + "/" + (subSpace == null ? "" : subSpace) + "/" + (search == null ? "" : search));
        }
        return ret != null;
    }

    public void navigateBack() {
        if (this.history.size() == 0) {
            return;
        }
        String link = this.history.removeLast();
        if (this.history.size() == 0) {
            return;
        }
        link = this.history.getLast();
        this.doUpdateHistoryMenu();
        String[] parts = link.split("\\|", 4);
        if (parts[2].equals("null")) {
            parts[2] = null;
        }
        if (parts[3].equals("null")) {
            parts[3] = null;
        }
        this.openSpace(parts[1], parts[2], parts[3], false, true);
    }

    public GuiSpaceService getSpace(String name) {
        return this.spaceList.get(name);
    }

    public GuiApi getApi() {
        return this.api;
    }

    public void close() {
        this.spaceList.clear();
        for (AbstractComponent v : this.spaceInstanceList.values()) {
            if (!(v instanceof GuiLifecycle)) continue;
            ((GuiLifecycle)v).doDestroy();
        }
        this.spaceInstanceList.clear();
    }

    public void addSpace(GuiSpaceService service) {
        log.d(new Object[]{"add space", service});
        this.spaceList.put(service.getName(), service);
        this.refreshSpaceList();
    }

    public void removeSpace(GuiSpaceService service) {
        log.d(new Object[]{"remove space", service});
        this.spaceList.remove(service.getName());
        AbstractComponent v = this.spaceInstanceList.remove(service.getName());
        if (v != null && v instanceof GuiLifecycle) {
            ((GuiLifecycle)v).doDestroy();
        }
        this.refreshSpaceList();
    }

    public AbstractComponent getSpaceComponent(String name) {
        GuiSpaceService space = this.spaceList.get(name);
        if (space == null) {
            return null;
        }
        AbstractComponent instance = this.spaceInstanceList.get(name);
        if (instance == null) {
            instance = space.createSpace();
            if (instance == null) {
                return null;
            }
            if (instance instanceof GuiLifecycle) {
                ((GuiLifecycle)instance).doInitialize();
            }
            this.spaceInstanceList.put(name, instance);
        }
        return instance;
    }

    public HelpContext getHelpContext(String name) {
        GuiSpaceService space = this.spaceList.get(name);
        if (space == null) {
            return null;
        }
        HelpContext instance = this.helpInstanceList.get(name);
        if (instance == null) {
            Locale locale = UI.getCurrent().getPage().getWebBrowser().getLocale();
            instance = space.createHelpContext(locale);
            if (instance == null) {
                return null;
            }
            if (instance instanceof GuiLifecycle) {
                ((GuiLifecycle)((Object)instance)).doInitialize();
            }
            this.helpInstanceList.put(name, instance);
        }
        return instance;
    }

    public MNls getNls() {
        if (this.nls == null) {
            this.nls = MNls.lookup((Object)((Object)this));
        }
        return this.nls;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getTileHorizontalGap() {
        return this.tileHorizontalGap;
    }

    public void setTileHorizontalGap(int tileHorizontalGap) {
        this.tileHorizontalGap = tileHorizontalGap;
    }
}

