/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.form.definition.FmNumber;
import de.mhus.lib.vaadin.form.UiVaadin;
import de.mhus.lib.vaadin.ui.SpinnerNumberField;

public class UiNumber
extends UiVaadin {
    private String type;

    @Override
    protected void setValue(Object value) throws MException {
        ((SpinnerNumberField)this.getComponentEditor()).setValue(MCast.toString((Object)value));
    }

    @Override
    public Component createEditor() {
        SpinnerNumberField spinner = null;
        this.type = this.getConfig().getString("number", "").toUpperCase();
        spinner = this.type.equals(FmNumber.TYPES.DOUBLE.name()) ? new SpinnerNumberField(Double.class) : (this.type.equals(FmNumber.TYPES.FLOAT.name()) ? new SpinnerNumberField(Float.class) : (this.type.equals(FmNumber.TYPES.LONG.name()) ? new SpinnerNumberField(Long.class) : new SpinnerNumberField(Integer.class)));
        spinner.setAllowNegative(this.getConfig().getBoolean("allow_negative", true));
        spinner.setAllowNull(this.getConfig().getBoolean("allow_null", false));
        spinner.setMaxVal(this.getConfig().getLong("max", Long.MAX_VALUE));
        spinner.setMinVal(this.getConfig().getLong("min", Long.MIN_VALUE));
        return spinner;
    }

    @Override
    protected Object getValue() throws MException {
        return ((SpinnerNumberField)this.getComponentEditor()).getValue();
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiNumber();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

