/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.container;

import com.vaadin.v7.ui.Table;
import de.mhus.lib.annotations.vaadin.Align;
import de.mhus.lib.annotations.vaadin.Column;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.vaadin.ColumnModel;
import de.mhus.lib.vaadin.MhuTable;
import de.mhus.lib.vaadin.container.MhuAbstractBeanContainer;
import de.mhus.lib.vaadin.container.MhuBeanItem;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;

public class MhuBeanItemContainer<BEANTYPE>
extends MhuAbstractBeanContainer<BEANTYPE, BEANTYPE> {
    public void refresh() {
        this.fireItemSetChange();
    }

    public void configureTableByAnnotations(Table table, String schema, MNls nls) {
        Column columnDef;
        MhuBeanItem.PojoPropertyDescriptor descriptor;
        TreeMap<Integer, String> columns = new TreeMap<Integer, String>();
        int nextOrderId = 100;
        for (String colId : this.getContainerPropertyIds()) {
            descriptor = (MhuBeanItem.PojoPropertyDescriptor)this.model.get(colId);
            columnDef = (Column)descriptor.getPojoAttribute().getAnnotation(Column.class);
            if (columnDef == null || (!MString.isEmpty((String)schema) || columnDef.schema().length != 0) && !MCollection.contains((Object[])columnDef.schema(), (Object)schema)) continue;
            int order = columnDef.order();
            if (order < 0) {
                order = ++nextOrderId;
            }
            columns.put(order, colId);
        }
        table.setVisibleColumns(columns.values().toArray());
        for (String colId : columns.values()) {
            descriptor = (MhuBeanItem.PojoPropertyDescriptor)this.model.get(colId);
            columnDef = (Column)descriptor.getPojoAttribute().getAnnotation(Column.class);
            String title = null;
            if (nls != null) {
                String n = colId;
                if (MString.isSet((String)columnDef.nls())) {
                    n = columnDef.nls();
                }
                title = nls.find(n);
            }
            if (title == null && !MString.isEmpty((String)columnDef.title())) {
                title = columnDef.title();
            }
            if (title != null) {
                table.setColumnHeader((Object)colId, title);
            }
            table.setColumnAlignment((Object)colId, MhuBeanItemContainer.mapToVaadin(columnDef.align()));
            table.setColumnCollapsed((Object)colId, !columnDef.elapsed());
            table.setColumnCollapsible((Object)colId, columnDef.collapsible());
            if (!(table instanceof MhuTable)) continue;
            ColumnModel model = ((MhuTable)table).getColumnModel(colId);
            model.configureByAnnotation(columnDef, descriptor.getPojoAttribute().canWrite());
            table.setConverter((Object)colId, model.generateConverter(descriptor.getPropertyType()));
        }
    }

    public static Table.Align mapToVaadin(Align align) {
        switch (align) {
            case CENTER: {
                return Table.Align.CENTER;
            }
            case LEFT: {
                return Table.Align.LEFT;
            }
            case RIGHT: {
                return Table.Align.RIGHT;
            }
        }
        return Table.Align.LEFT;
    }

    public MhuBeanItemContainer(Class<? super BEANTYPE> type) throws IllegalArgumentException {
        super(type);
        super.setBeanIdResolver(new IdentityBeanIdResolver());
    }

    @Deprecated
    public MhuBeanItemContainer(Collection<? extends BEANTYPE> collection) throws IllegalArgumentException {
        this(MhuBeanItemContainer.getBeanClassForCollection(collection), collection);
    }

    @Deprecated
    private static <BT> Class<? extends BT> getBeanClassForCollection(Collection<? extends BT> collection) throws IllegalArgumentException {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("The collection passed to BeanItemContainer constructor must not be null or empty. Use the other BeanItemContainer constructor.");
        }
        return collection.iterator().next().getClass();
    }

    public MhuBeanItemContainer(Class<? super BEANTYPE> type, Collection<? extends BEANTYPE> collection) throws IllegalArgumentException {
        super(type);
        super.setBeanIdResolver(new IdentityBeanIdResolver());
        if (collection != null) {
            this.addAll(collection);
        }
    }

    @Override
    public void addAll(Collection<? extends BEANTYPE> collection) {
        super.addAll(collection);
    }

    public MhuBeanItem<BEANTYPE> addItemAfter(Object previousItemId, Object newItemId) throws IllegalArgumentException {
        return super.addBeanAfter(previousItemId, newItemId);
    }

    public MhuBeanItem<BEANTYPE> addItemAt(int index, Object newItemId) throws IllegalArgumentException {
        return super.addBeanAt(index, newItemId);
    }

    public MhuBeanItem<BEANTYPE> addItem(Object itemId) {
        return super.addBean(itemId);
    }

    @Override
    public MhuBeanItem<BEANTYPE> addBean(BEANTYPE bean) {
        return this.addItem(bean);
    }

    @Override
    protected void setBeanIdResolver(MhuAbstractBeanContainer.BeanIdResolver<BEANTYPE, BEANTYPE> beanIdResolver) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("BeanItemContainer always uses an IdentityBeanIdResolver");
    }

    @Override
    public boolean mergeAll(Collection<? extends BEANTYPE> collection, boolean remove, Comparator<BEANTYPE> comparator) {
        return super.mergeAll(collection, remove, comparator);
    }

    private static class IdentityBeanIdResolver<BT>
    implements MhuAbstractBeanContainer.BeanIdResolver<BT, BT> {
        private IdentityBeanIdResolver() {
        }

        @Override
        public BT getIdForBean(BT bean) {
            return bean;
        }
    }
}

