/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.MObserverHandler;
import de.mhus.lib.vaadin.CardButton;
import de.mhus.lib.vaadin.ui.Border;
import java.util.LinkedList;

public class SectionsSelector
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    LinkedList<Section> sections = new LinkedList();
    private String bWidth = "100px";
    private String bHeight = "100px";
    private String bSelectedColor = "#AAA";
    private String bNotSelectedColor = "#999";
    private String bDisabledColor = "#555";
    private MObserverHandler eventHandler = new MObserverHandler();
    private boolean autoSelect = true;

    public SectionsSelector() {
        this.setWidth(this.bWidth);
    }

    public Section addSection(String name, String title) {
        return this.addSection(name, title, null);
    }

    public Section addSection(String name, String title, Object userData) {
        Section section = this.getSection(name);
        if (section != null) {
            section.setTitle(title);
            if (userData != null) {
                section.setUserData(userData);
            }
            this.eventHandler.fireChanged((Object)new Event(this, EVENTS.UPDATED, section));
        } else {
            section = new Section(name, title);
            section.setUserData(userData);
            this.eventHandler.fireChanged((Object)new Event(this, EVENTS.ADDED, section));
            if (this.autoSelect && this.sections.size() == 1) {
                this.setSelected(name);
            }
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section getSection(String name) {
        LinkedList<Section> linkedList = this.sections;
        synchronized (linkedList) {
            for (Section section : this.sections) {
                if (!section.getName().equals(name)) continue;
                return section;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section getSelected() {
        LinkedList<Section> linkedList = this.sections;
        synchronized (linkedList) {
            for (Section section : this.sections) {
                if (!section.isSelected()) continue;
                return section;
            }
        }
        return null;
    }

    public String getButtonWidth() {
        return this.bWidth;
    }

    public void setButtonWidth(String bWidth) {
        this.bWidth = bWidth;
        this.setWidth(bWidth);
    }

    public String getButtonHeight() {
        return this.bHeight;
    }

    public void setButtonHeight(String bHeight) {
        this.bHeight = bHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section setSelected(String name) {
        this.eventHandler.fireChanged((Object)new Event(this, EVENTS.SECTION_CHANGEING, this.getSection(name)));
        Section sel = null;
        LinkedList<Section> linkedList = this.sections;
        synchronized (linkedList) {
            for (Section section : this.sections) {
                if (section.getName().equals(name)) {
                    section.setSelected(true);
                    sel = section;
                    continue;
                }
                section.setSelected(false);
            }
        }
        this.eventHandler.fireChanged((Object)new Event(this, EVENTS.SECTION_CHANGED, this.getSection(name)));
        return sel;
    }

    public MObserverHandler eventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section removeSection(String name) {
        LinkedList<Section> linkedList;
        Section sec = this.getSection(name);
        if (this.autoSelect && sec.isSelected()) {
            linkedList = this.sections;
            synchronized (linkedList) {
                for (Section section : this.sections) {
                    if (!section.isEnabled()) continue;
                    this.setSelected(section.getName());
                    break;
                }
            }
        }
        linkedList = this.sections;
        synchronized (linkedList) {
            if (sec == null) {
                return null;
            }
            this.sections.remove(sec);
        }
        this.eventHandler.fireChanged((Object)new Event(this, EVENTS.REMOVED, sec));
        return sec;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    public static class Event {
        private SectionsSelector source;
        private EVENTS event;
        private Section section;

        private Event(SectionsSelector source, EVENTS event, Section section) {
            this.source = source;
            this.event = event;
            this.section = section;
        }

        public SectionsSelector getSource() {
            return this.source;
        }

        public EVENTS getEvent() {
            return this.event;
        }

        public Section getSection() {
            return this.section;
        }
    }

    public class Section
    implements Button.ClickListener {
        private static final long serialVersionUID = 1L;
        private String name;
        private String title;
        private CardButton button;
        private boolean enabled = true;
        private boolean selected = false;
        private Object userData;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Section(String name, String title) {
            this.name = name;
            this.title = title;
            this.button = new CardButton(title);
            this.button.setWidth(SectionsSelector.this.bWidth);
            this.button.setHeight(SectionsSelector.this.bHeight);
            this.button.setBorder(new Border(1, 1, 1, 1));
            this.button.setMargin(new Border(1, 0, 0, 0));
            this.button.setData(name);
            this.button.addClickListener(this);
            this.doUpdate();
            LinkedList<Section> linkedList = SectionsSelector.this.sections;
            synchronized (linkedList) {
                SectionsSelector.this.sections.add(this);
                SectionsSelector.this.addComponent((Component)this.button);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
            this.button.setCaption(title);
        }

        @Deprecated
        public Button getButton() {
            return this.button;
        }

        private void setSelected(boolean selected) {
            this.selected = selected;
            this.doUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate() {
            if (!this.enabled) {
                this.button.setBackgroundColor(SectionsSelector.this.bDisabledColor);
                if (SectionsSelector.this.autoSelect && this.selected) {
                    LinkedList<Section> linkedList = SectionsSelector.this.sections;
                    synchronized (linkedList) {
                        for (Section section : SectionsSelector.this.sections) {
                            if (!section.isEnabled()) continue;
                            section.setSelected(true);
                            break;
                        }
                    }
                    this.selected = false;
                }
            } else if (this.selected) {
                this.button.setBackgroundColor(SectionsSelector.this.bSelectedColor);
            } else {
                this.button.setBackgroundColor(SectionsSelector.this.bNotSelectedColor);
            }
            this.button.updateCaption();
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.doUpdate();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void buttonClick(Button.ClickEvent event) {
            if (!this.enabled) {
                return;
            }
            SectionsSelector.this.setSelected(this.name);
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }
    }

    public static enum EVENTS {
        SECTION_CHANGEING,
        SECTION_CHANGED,
        ADDED,
        REMOVED,
        UPDATED;

    }
}

