/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import de.mhus.lib.core.util.FilterRequest;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;

public class SearchField
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private ComboBox filter;
    private Listener listener;
    private Button bSearch;
    private MNlsProvider nlsProvider;

    public SearchField(MNlsProvider nlsProvider) {
        this.nlsProvider = nlsProvider;
        this.filter = new ComboBox();
        this.filter.setNewItemsAllowed(true);
        this.filter.setNewItemHandler(new AbstractSelect.NewItemHandler(){
            private static final long serialVersionUID = 1L;

            public void addNewItem(String newItemCaption) {
                SearchField.this.addKnownFacetName(newItemCaption);
                SearchField.this.filter.setValue((Object)newItemCaption);
            }
        });
        this.filter.setInputPrompt(MNls.find((MNlsProvider)nlsProvider, (String)"filter.prompt=Filter"));
        this.filter.setImmediate(true);
        this.filter.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                SearchField.this.doFilter();
            }
        });
        this.addComponent((Component)this.filter);
        this.setExpandRatio((Component)this.filter, 1.0f);
        this.filter.setWidth("100%");
        this.bSearch = new Button();
        this.bSearch.setIcon((Resource)FontAwesome.SEARCH);
        this.bSearch.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                SearchField.this.doFilter();
            }
        });
        this.addComponent((Component)this.bSearch);
        this.setExpandRatio((Component)this.bSearch, 0.0f);
        this.setWidth("100%");
    }

    protected void doFilter() {
        if (this.listener != null) {
            this.listener.doFilter(this);
        }
    }

    public void setInputPrompt(String prompt) {
        this.filter.setInputPrompt(prompt);
    }

    public void setValue(String value) {
        this.filter.setValue((Object)value);
    }

    public FilterRequest createFilterRequest() {
        return new FilterRequest((String)this.filter.getValue());
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void addKnownFacetName(String name) {
        if (!this.filter.containsId((Object)name)) {
            this.filter.addItem((Object)name);
        }
    }

    public static interface Listener {
        public void doFilter(SearchField var1);
    }
}

