/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import de.mhus.lib.vaadin.MVaadinApplication;

public class MVaadinPortlet
extends MVaadinApplication {
    private static final long serialVersionUID = 1L;
    protected VerticalLayout layout;
    protected Window window;
    private HorizontalLayout control;
    private Button bHeightAdd;
    private Button bHeightSub;
    private Button bWidthAdd;
    private Button bWidthSub;
    private Button bFull;
    private boolean isFull = true;
    private int width;
    private int height;
    private boolean hasButtons = true;

    @Override
    public void doContent(VerticalLayout innerLayout) {
        this.layout = new VerticalLayout();
        this.layout.setSizeFull();
        innerLayout.addComponent((Component)this.layout);
        innerLayout.setExpandRatio((Component)this.layout, 1.0f);
        innerLayout.setMargin(false);
        this.control = new HorizontalLayout();
        innerLayout.addComponent((Component)this.control);
        innerLayout.setExpandRatio((Component)this.control, 0.0f);
        innerLayout.setComponentAlignment((Component)this.control, Alignment.TOP_RIGHT);
        this.control.setWidth("100%");
        if (this.hasButtons) {
            this.createCustomButtons(this.control);
            this.bHeightAdd = new Button(" \\/ ");
            this.bHeightAdd.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MVaadinPortlet.this.doAddHeight();
                }
            });
            this.control.addComponent((Component)this.bHeightAdd);
            this.bHeightSub = new Button(" /\\ ");
            this.bHeightSub.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MVaadinPortlet.this.doSubHeight();
                }
            });
            this.control.addComponent((Component)this.bHeightSub);
            this.bWidthAdd = new Button(" > ");
            this.bWidthAdd.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MVaadinPortlet.this.doAddWidth();
                }
            });
            this.control.addComponent((Component)this.bWidthAdd);
            this.bWidthSub = new Button(" < ");
            this.bWidthSub.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MVaadinPortlet.this.doSubWidth();
                }
            });
            this.control.addComponent((Component)this.bWidthSub);
            this.bFull = new Button(" * ");
            this.bFull.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MVaadinPortlet.this.doFull();
                }
            });
            this.control.addComponent((Component)this.bFull);
            this.control.addComponent((Component)new Label("  "));
        }
        this.window.setResizable(true);
        int[] size = this.getRememberedSize();
        this.isFull = false;
        this.setHeight(size[1]);
        this.setWidth(size[0]);
        this.setFullSize(size[2] == 1);
    }

    protected void createCustomButtons(HorizontalLayout buttonBar) {
    }

    protected void doFull() {
        this.isFull = !this.isFull;
        this.setFullSize(this.isFull);
    }

    public void setFullSize(boolean full) {
        VerticalLayout innerLayout = (VerticalLayout)this.getContent();
        if (full) {
            innerLayout.setWidth("100%");
        } else {
            this.isFull = false;
            this.setWidth(this.width);
            this.setHeight(this.height);
        }
        this.isFull = full;
        if (this.hasButtons) {
            this.bFull.setCaption(full ? " * " : " o ");
            this.bWidthAdd.setEnabled(!full);
            this.bWidthSub.setEnabled(!full);
        }
    }

    protected void doSubHeight() {
        this.setHeight(this.height - 50);
    }

    protected void doAddHeight() {
        this.setHeight(this.height + 50);
    }

    protected void doSubWidth() {
        this.setWidth(this.width - 50);
    }

    protected void doAddWidth() {
        this.setWidth(this.width + 50);
    }

    protected void doRememberSize(int[] opts) {
    }

    protected int[] getRememberedSize() {
        return new int[]{1000, 600, 1};
    }

    @Override
    public void close() {
        super.close();
    }

    protected VerticalLayout getLayoutContent() {
        return this.layout;
    }

    public void setHeight(int height) {
        if (height < 0) {
            return;
        }
        VerticalLayout innerLayout = (VerticalLayout)this.getContent();
        innerLayout.setHeight((float)height, Sizeable.Unit.PIXELS);
        this.height = height;
        this.doRememberSize(new int[]{this.width, height, this.isFull ? 1 : 0});
    }

    public void setWidth(int width) {
        if (width < 0) {
            return;
        }
        VerticalLayout innerLayout = (VerticalLayout)this.getContent();
        if (!this.isFull) {
            innerLayout.setWidth((float)width, Sizeable.Unit.PIXELS);
        }
        this.width = width;
        this.doRememberSize(new int[]{width, this.height, this.isFull ? 1 : 0});
    }

    public boolean isHasButtons() {
        return this.hasButtons;
    }

    protected void setHasButtons(boolean hasButtons) {
        this.hasButtons = hasButtons;
    }
}

