/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.vaadin.AbstractBeanListEditor;
import de.mhus.lib.vaadin.ManagedListEntity;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class LinkedListEditor<E>
extends AbstractBeanListEditor<E> {
    private static final long serialVersionUID = 1L;
    protected LinkedList<E> list = new LinkedList();
    protected HashSet<E> deleted = new HashSet();
    protected HashSet<E> changed = new HashSet();
    protected HashSet<E> created = new HashSet();
    private PojoAttribute<Object> idAttribute;

    public LinkedListEditor(Class<E> beanClass, String schema, String idAttribute) {
        super(beanClass, schema);
        this.idAttribute = this.beanModel.getAttribute(idAttribute);
    }

    @Override
    protected E getEditableTarget(Object id) {
        E original = this.getTarget(id);
        E clone = this.createTarget();
        for (PojoAttribute attr : this.beanModel) {
            try {
                Object value = attr.get(original);
                attr.set(clone, value);
            }
            catch (Throwable throwable) {}
        }
        return clone;
    }

    @Override
    protected E createTarget() {
        try {
            Object out = this.beanClass.newInstance();
            if (out instanceof ManagedListEntity) {
                ((ManagedListEntity)out).doPostCreate(this);
            }
            return (E)out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void doCancel(E entry) {
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doCancel(this);
        }
    }

    @Override
    public void doDelete(E entry) {
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPreDelete(this);
        }
        if (this.created.contains(entry)) {
            this.created.remove(entry);
        } else {
            this.deleted.add(entry);
        }
        this.list.remove(entry);
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPostDelete(this);
        }
        this.setModified(true);
    }

    @Override
    public void doSave(E entry) {
        Object id;
        Object original;
        if (entry instanceof ManagedListEntity) {
            ((ManagedListEntity)entry).doPreSave(this);
        }
        Object e = original = (id = this.getId(entry)) != null ? (Object)this.getTarget(id) : null;
        if (original == null) {
            this.doSaveNew(entry);
            this.setModified(true);
            return;
        }
        for (PojoAttribute attr : this.beanModel) {
            try {
                Object value = attr.get(entry);
                attr.set(original, value);
            }
            catch (Throwable throwable) {}
        }
        if (!this.created.contains(original)) {
            this.changed.add(original);
        }
        if (original instanceof ManagedListEntity) {
            ((ManagedListEntity)original).doPostSave(this);
        }
        this.setModified(true);
    }

    @Override
    protected E getTarget(Object id) {
        for (Object item : this.list) {
            if (!this.getId(item).equals(id)) continue;
            return item;
        }
        return null;
    }

    @Override
    protected Object getId(E entry) {
        try {
            Object id;
            if (entry instanceof ManagedListEntity && (id = ((ManagedListEntity)entry).doGetId(this)) != null) {
                return id;
            }
            return this.idAttribute.get(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected List<E> createBeanDataList() {
        return this.list;
    }

    @Override
    protected void doSaveNew(E entry) {
        Object id = this.createId();
        try {
            boolean done = false;
            if (entry instanceof ManagedListEntity) {
                done = ((ManagedListEntity)entry).doPreNew(this, id);
            }
            if (!done) {
                this.idAttribute.set(entry, id);
            }
            this.list.add(entry);
            this.created.add(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Object createId() {
        return UUID.randomUUID().toString();
    }

    public void applyChanges() {
        this.created.clear();
        this.deleted.clear();
        this.changed.clear();
    }
}

