/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.ui.Button;
import de.mhus.lib.core.MXml;
import de.mhus.lib.vaadin.ui.Border;

public class CardButton
extends Button {
    private static final long serialVersionUID = 1L;
    private String caption;
    private Border border;
    private String backgroundColor;
    private String foregroundColor;
    private Border margin = new Border(1, 1, 1, 1);
    private Border padding = new Border(5, 5, 5, 5);
    private boolean centerVertical = true;

    public CardButton(String caption) {
        this();
        this.setCaption(caption);
    }

    public CardButton() {
        this.setCaptionAsHtml(true);
        this.setStyleName("link");
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.updateCaption();
    }

    public void updateCaption() {
        if (this.getIcon() != null) {
            this.setCaption("");
            return;
        }
        String c = "<div style='";
        int innerWidth = 0;
        int innerHeight = 0;
        if (this.getHeightUnits() == UNITS_PIXELS) {
            innerHeight = (int)this.getHeight();
            if (this.margin != null) {
                innerHeight -= this.margin.top + this.margin.bottom;
            }
            if (this.padding != null) {
                innerHeight -= this.padding.top + this.padding.bottom;
            }
            if (this.border != null) {
                innerHeight -= this.border.top + this.border.bottom;
            }
        }
        if (this.getWidthUnits() == UNITS_PIXELS) {
            innerWidth = (int)this.getWidth();
            if (this.margin != null) {
                innerWidth -= this.margin.left + this.margin.right;
            }
            if (this.padding != null) {
                innerWidth -= this.padding.left + this.padding.right;
            }
            if (this.border != null) {
                innerWidth -= this.border.left + this.border.right;
            }
        }
        c = innerWidth > 0 ? c + "width:" + innerWidth + "px;" : c + "width:auto;";
        c = innerHeight > 0 ? c + "height:" + innerHeight + "px;" : c + "height:auto;";
        if (this.margin != null) {
            c = c + "margin:" + this.margin.toStyle();
        }
        if (this.padding != null) {
            c = c + "padding:" + this.padding.toStyle();
        }
        if (this.border != null) {
            c = c + this.border.toBorderStyle() + ";";
        }
        if (this.backgroundColor != null) {
            c = c + "background-color:" + this.backgroundColor + ";";
        }
        if (this.foregroundColor != null) {
            c = c + "color:" + this.foregroundColor + ";";
        }
        c = c + "'>";
        if (this.centerVertical) {
            c = c + "<div style='display:table-cell;vertical-align:middle;height:" + innerHeight + "px'>";
        }
        c = c + MXml.encode((String)this.caption);
        if (this.centerVertical) {
            c = c + "</div>";
        }
        c = c + "</div>";
        super.setCaption(c);
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Border getMargin() {
        return this.margin;
    }

    public void setMargin(Border margin) {
        this.margin = margin;
    }

    public Border getPadding() {
        return this.padding;
    }

    public void setPadding(Border padding) {
        this.padding = padding;
    }

    public boolean isCenterVertical() {
        return this.centerVertical;
    }

    public void setCenterVertical(boolean centerVertical) {
        this.centerVertical = centerVertical;
    }
}

