/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import de.mhus.lib.annotations.pojo.Hidden;
import de.mhus.lib.core.ILog;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.FilterRequest;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsBundle;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.form.MutableMForm;
import de.mhus.lib.vaadin.ColumnDefinition;
import de.mhus.lib.vaadin.ConfirmDialog;
import de.mhus.lib.vaadin.SearchField;
import de.mhus.lib.vaadin.SimpleTable;
import de.mhus.lib.vaadin.form.VaadinPojoForm;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractListEditor<E>
extends VerticalLayout
implements MNlsProvider,
ILog {
    private static final long serialVersionUID = 1L;
    protected static final Object MY_NEW_MARKER = new Object();
    public static final String LABEL_SAVED_NEW = "entity.new=new";
    public static final String LABEL_SAVED = "entity.saved=saved";
    public static final String LABEL_DELETED = "entity.deleted=deleted";
    public static final String LABEL_CANELED = "entity.canceled=canceled";
    protected SimpleTable table;
    private Button bNew;
    private Button bUpdate;
    private Button bDelete;
    protected Object editMode;
    protected VaadinPojoForm<E> model;
    protected SearchField filter;
    private boolean showSearchField = true;
    private boolean needSortUpdate = false;
    private Panel detailsPanel;
    private boolean fullSize;
    private VerticalLayout detailsPanelContent;
    private MNlsBundle nlsBundle;
    private boolean modified = false;
    private boolean initialized = false;
    @Hidden
    private Log log = Log.getLog((Object)((Object)this));
    private String sortedColumn;
    private boolean sortedAscending;

    public void initUI() {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized(true);
        if (this.fullSize) {
            this.setSizeFull();
        }
        this.setSpacing(true);
        this.setMargin(true);
        this.filter = new SearchField(this);
        this.filter.setListener(new SearchField.Listener(){

            @Override
            public void doFilter(SearchField searchField) {
                AbstractListEditor.this.doFilter();
            }
        });
        this.table = new SimpleTable(this.getTableName());
        this.table.setSelectable(true);
        this.table.setMultiSelect(false);
        this.table.setImmediate(true);
        this.table.setSizeFull();
        this.table.createDataSource(this.createColumnDefinitions());
        this.fillDataSource(new FilterRequest(""));
        this.table.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                AbstractListEditor.this.doSelectionChanged();
            }
        });
        this.table.addItemClickListener(new ItemClickEvent.ItemClickListener(){

            public void itemClick(ItemClickEvent event) {
                AbstractListEditor.this.doItemClick(event);
            }
        });
        this.table.addHeaderClickListener(new Table.HeaderClickListener(){

            public void headerClick(Table.HeaderClickEvent event) {
                String name = String.valueOf(event.getPropertyId());
                if (name.equals(AbstractListEditor.this.sortedColumn)) {
                    AbstractListEditor.this.sortedAscending = !AbstractListEditor.this.sortedAscending;
                } else {
                    AbstractListEditor.this.sortedAscending = true;
                }
                AbstractListEditor.this.sortedColumn = name;
                if (AbstractListEditor.this.needSortUpdate) {
                    AbstractListEditor.this.updateDataSource();
                }
            }
        });
        this.detailsPanel = new Panel(this.getDetailsName());
        this.detailsPanel.setWidth("100%");
        this.detailsPanelContent = new VerticalLayout();
        this.detailsPanel.setContent((Component)this.detailsPanelContent);
        if (this.fullSize) {
            this.detailsPanel.setSizeFull();
        }
        try {
            this.model = this.createForm();
            if (this.model.getForm().getNlsBundle() == null && this.model.getForm() instanceof MutableMForm) {
                ((MutableMForm)this.model.getForm()).setNlsBundle(MNlsBundle.lookup((Object)((Object)this)));
            }
            this.model.doBuild();
            this.detailsPanelContent.addComponent(this.model);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HorizontalLayout buttonBar = new HorizontalLayout();
        this.bNew = new Button(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
        buttonBar.addComponent((Component)this.bNew);
        this.bNew.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doNew();
            }
        });
        this.bUpdate = new Button(MNls.find((MNlsProvider)this, (String)"button.edit=Edit"));
        buttonBar.addComponent((Component)this.bUpdate);
        this.bUpdate.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doUpdate();
            }
        });
        this.bDelete = new Button(MNls.find((MNlsProvider)this, (String)"button.delete=Delete"));
        buttonBar.addComponent((Component)this.bDelete);
        this.bDelete.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AbstractListEditor.this.doDelete();
            }
        });
        this.editMode = null;
        this.createCustomButtons(buttonBar);
        this.composeElements((AbstractComponent)this.filter, (AbstractComponent)this.table, (AbstractComponent)this.detailsPanel, (AbstractComponent)buttonBar);
        this.updateEnabled();
    }

    protected void doItemClick(ItemClickEvent event) {
        if (this.editMode == null && event.isDoubleClick()) {
            this.doUpdate();
        }
    }

    protected MActivator getActivator() {
        return null;
    }

    protected void createCustomButtons(HorizontalLayout buttonBar) {
    }

    protected String getDetailsName() {
        return MNls.find((MNlsProvider)this, (String)"panel.details.caption=Details");
    }

    protected void doFilter() {
        this.updateDataSource();
    }

    protected void composeElements(AbstractComponent filter, AbstractComponent table, AbstractComponent formPanel, AbstractComponent buttonBar) {
        if (this.showSearchField) {
            this.addComponent((Component)filter);
        }
        VerticalSplitPanel split = new VerticalSplitPanel();
        split.setFirstComponent((Component)table);
        table.setSizeUndefined();
        table.setSizeFull();
        split.setSecondComponent((Component)formPanel);
        split.setSizeFull();
        this.addComponent((Component)split);
        this.setExpandRatio((Component)split, 1.0f);
        this.addComponent((Component)buttonBar);
        this.setSizeFull();
    }

    protected abstract ColumnDefinition[] createColumnDefinitions();

    protected String getTableName() {
        return MNls.find((MNlsProvider)this, (String)"panel.table.caption=Table");
    }

    protected abstract E createTarget();

    protected VaadinPojoForm<E> createForm() {
        try {
            VaadinPojoForm<E> form = new VaadinPojoForm<E>(this.createTarget());
            form.setPojo(this.createTarget());
            return form;
        }
        catch (Throwable t) {
            this.log.w(new Object[]{t});
            return null;
        }
    }

    protected void doSelectionChanged() {
        if (this.editMode != null) {
            return;
        }
        Object selectedId = this.table.getValue();
        Object target = null;
        target = selectedId == null ? (Object)this.createTarget() : (Object)this.getTarget(selectedId);
        this.model.setPojo(target);
        this.updateEnabled();
    }

    protected void doDelete() {
        if (this.editMode != null) {
            this.doCancel();
            return;
        }
        Object selectedId = this.table.getValue();
        if (selectedId == null || !this.canDelete(selectedId)) {
            return;
        }
        final E selectedObj = this.getTarget(selectedId);
        if (selectedObj == null) {
            return;
        }
        ConfirmDialog.show(this.getUI(), MNls.find((MNlsProvider)this, (String)"confirm.delete=Delete"), MNls.find((MNlsProvider)this, (String)"confirm.question=Are you sure?"), MNls.find((MNlsProvider)this, (String)"confirm.yes=Yes"), MNls.find((MNlsProvider)this, (String)"confirm.no=Cancel"), new ConfirmDialog.Listener(){

            @Override
            public void onClose(ConfirmDialog dialog) {
                if (dialog.isConfirmed()) {
                    try {
                        AbstractListEditor.this.doDelete(selectedObj);
                        AbstractListEditor.this.showInformation(MNls.find((MNlsProvider)AbstractListEditor.this, (String)AbstractListEditor.LABEL_DELETED));
                    }
                    catch (Throwable e) {
                        AbstractListEditor.this.log().i(new Object[]{e});
                        AbstractListEditor.this.showError(e);
                    }
                    AbstractListEditor.this.model.setPojo(AbstractListEditor.this.createTarget());
                    AbstractListEditor.this.updateDataSource();
                    AbstractListEditor.this.modified = true;
                }
            }
        });
    }

    protected void doCancel() {
        if (this.editMode == null) {
            return;
        }
        try {
            if (!MY_NEW_MARKER.equals(this.editMode)) {
                this.doCancel(this.getTarget(this.editMode));
                this.showInformation(MNls.find((MNlsProvider)this, (String)LABEL_CANELED));
            }
        }
        catch (Throwable t) {
            this.log().i(new Object[]{t});
            this.showError(t);
        }
        this.editMode = null;
        this.model.setPojo(this.createTarget());
        this.updateEnabled();
    }

    protected abstract void doCancel(E var1) throws Exception;

    protected abstract void doDelete(E var1) throws Exception;

    protected void doUpdate() {
        if (this.editMode == null) {
            Object selectedId = this.table.getValue();
            if (selectedId == null || !this.canUpdate(selectedId)) {
                return;
            }
            try {
                this.doUpdate(selectedId);
            }
            catch (Exception e) {
                this.log().i(new Object[]{e});
            }
        } else {
            try {
                if (!this.canUpdate(this.editMode)) {
                    return;
                }
                E entity = this.model.getPojo();
                if (MY_NEW_MARKER.equals(this.editMode)) {
                    String error = this.doValidateNew(entity);
                    if (error != null) {
                        this.showError(error);
                        return;
                    }
                    this.doSaveNew(entity);
                    this.showInformation(MNls.find((MNlsProvider)this, (String)LABEL_SAVED_NEW));
                } else {
                    String error = this.doValidate(entity);
                    if (error != null) {
                        this.showError(error);
                        return;
                    }
                    this.doSave(entity);
                    this.showInformation(MNls.find((MNlsProvider)this, (String)LABEL_SAVED));
                }
                this.updateDataSource();
                this.modified = true;
                this.editMode = null;
            }
            catch (Throwable e) {
                this.log().i(new Object[]{e});
                this.showError(e);
            }
        }
        this.updateEnabled();
    }

    protected String doValidateNew(E entity) {
        return null;
    }

    protected String doValidate(E entity) {
        return null;
    }

    public void showError(Throwable e) {
        this.showError(e.getMessage());
    }

    public void showError(String e) {
        Notification.show((String)e, (Notification.Type)Notification.Type.ERROR_MESSAGE);
    }

    public void showInformation(String msg) {
        if (MString.isEmpty((String)msg)) {
            return;
        }
        Notification.show((String)msg, (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
    }

    protected void doSaveNew(E entity) throws Exception {
        this.doSave(entity);
    }

    protected void doUpdate(Object selectedId) {
        this.editMode = selectedId;
        if (MY_NEW_MARKER.equals(this.editMode)) {
            return;
        }
        E target = this.getEditableTarget(this.editMode);
        this.model.setPojo(target);
    }

    protected abstract void doSave(E var1) throws Exception;

    protected abstract E getEditableTarget(Object var1);

    protected abstract E getTarget(Object var1);

    protected void doNew() {
        if (this.editMode != null || !this.canNew()) {
            return;
        }
        this.editMode = MY_NEW_MARKER;
        this.model.setPojo(this.createTarget());
        this.updateEnabled();
    }

    protected void updateEnabled() {
        Object selectedId = this.table.getValue();
        if (!this.isEditMode()) {
            this.bNew.setEnabled(this.canNew());
            this.bNew.setCaption(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
            this.bUpdate.setEnabled(selectedId != null && this.canUpdate(selectedId));
            this.bUpdate.setCaption(MNls.find((MNlsProvider)this, (String)"button.edit=Edit"));
            this.bDelete.setEnabled(selectedId != null && this.canDelete(selectedId));
            this.bDelete.setCaption(MNls.find((MNlsProvider)this, (String)"button.delete=Delete"));
            if (this.model != null) {
                this.model.setEnabled(false);
            }
            this.table.setEnabled(true);
        } else {
            this.bNew.setEnabled(false);
            this.bNew.setCaption(MNls.find((MNlsProvider)this, (String)"button.create=Create"));
            this.bUpdate.setEnabled(true);
            this.bUpdate.setCaption(MNls.find((MNlsProvider)this, (String)"button.save=Set"));
            this.bDelete.setEnabled(true);
            this.bDelete.setCaption(MNls.find((MNlsProvider)this, (String)"button.cancel=Cancel"));
            this.model.setEnabled(true);
            this.table.setEnabled(false);
        }
        this.doUpdateEnabled(selectedId);
    }

    protected void doUpdateEnabled(Object selectedId) {
    }

    public boolean isEditMode() {
        return this.editMode != null;
    }

    public boolean canDelete(Object selectedId) {
        return true;
    }

    public boolean canUpdate(Object selectedId) {
        return true;
    }

    public boolean canNew() {
        return true;
    }

    protected void fillDataSource(FilterRequest filter) {
        try {
            this.table.removeAllItems();
            for (E entity : this.createDataList(filter)) {
                this.table.addRow(this.getId(entity), this.getValues(entity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract Object[] getValues(E var1);

    protected abstract Object getId(E var1);

    protected abstract List<E> createDataList(FilterRequest var1);

    public void updateDataSource() {
        try {
            LinkedList<Object> newIds = new LinkedList<Object>();
            for (E entity : this.createDataList(this.filter.createFilterRequest())) {
                Object[] values;
                Object id = this.getId(entity);
                if (!this.table.updateRow(id, values = this.getValues(entity))) {
                    this.table.addRow(id, values);
                }
                newIds.add(id);
            }
            for (E id : new LinkedList(this.table.getItemIds())) {
                if (newIds.contains(id)) continue;
                this.table.removeItem(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShowSearchField() {
        return this.showSearchField;
    }

    public void setShowSearchField(boolean showSearchField) {
        this.showSearchField = showSearchField;
    }

    public void doUpdateCaptions() {
        this.table.setCaption(this.getTableName());
        this.detailsPanel.setCaption(this.getDetailsName());
    }

    public E getSingleSelected() {
        if (this.isEditMode()) {
            return this.getTarget(this.editMode);
        }
        Object selectedId = this.table.getValue();
        if (selectedId == null) {
            return null;
        }
        return this.getTarget(selectedId);
    }

    public boolean isFullSize() {
        return this.fullSize;
    }

    public void setFullSize(boolean fullSize) {
        this.fullSize = fullSize;
    }

    public MNls getNls() {
        if (this.nlsBundle == null) {
            this.nlsBundle = MNlsBundle.lookup((Object)((Object)this));
        }
        return this.nlsBundle.getNls(UI.getCurrent().getLocale());
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public synchronized Log log() {
        if (this.log == null) {
            this.log = Log.getLog((Object)((Object)this));
        }
        return this.log;
    }

    public boolean isNeedSortUpdate() {
        return this.needSortUpdate;
    }

    public void setNeedSortUpdate(boolean needSortUpdate) {
        this.needSortUpdate = needSortUpdate;
    }

    public String getSortedColumn() {
        return this.sortedColumn;
    }

    public boolean isSortedAscending() {
        return this.sortedAscending;
    }

    public MNlsBundle getNlsBundle() {
        return this.nlsBundle;
    }

    public void setNlsBundle(MNlsBundle nlsBundle) {
        this.nlsBundle = nlsBundle;
    }
}

