/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.ui;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.MenuBar;
import de.mhus.lib.core.MString;
import java.util.Map;

public class HelpNavigation
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;

    public HelpNavigation(Map<String, MenuBar.Command> commands, final String helpUrl) {
        if (commands != null && !commands.isEmpty()) {
            MenuBar menuBar = new MenuBar();
            MenuBar.MenuItem menu = menuBar.addItem("Men\u00fc", null);
            menu.setIcon((Resource)FontAwesome.NAVICON);
            for (Map.Entry<String, MenuBar.Command> entry : commands.entrySet()) {
                menu.addItem(entry.getKey(), entry.getValue());
            }
            this.addComponent((Component)menuBar);
            this.setComponentAlignment((Component)menuBar, Alignment.MIDDLE_CENTER);
        }
        if (MString.isSetTrim((String)helpUrl)) {
            Button helpBtn = new Button("Hilfe");
            helpBtn.setIcon((Resource)FontAwesome.QUESTION);
            helpBtn.setDescription("Hier klicken, um Hilfe zu erhalten");
            helpBtn.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    HelpNavigation.this.getUI().getPage().open(helpUrl, "_blank", false);
                }
            });
            this.addComponent((Component)helpBtn);
            this.setComponentAlignment((Component)helpBtn, Alignment.MIDDLE_CENTER);
        }
        this.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setSpacing(true);
    }
}

