/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.ui;

import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import de.mhus.lib.vaadin.ui.HelpOverlay;
import java.util.ArrayList;
import java.util.List;

public class HelpManager {
    private UI ui;
    private List<HelpOverlay> overlays = new ArrayList<HelpOverlay>();

    public HelpManager(UI ui) {
        this.ui = ui;
    }

    public void closeAll() {
        for (HelpOverlay overlay : this.overlays) {
            overlay.close();
        }
        this.overlays.clear();
    }

    public void showHelp(String caption, String text, String style) {
        HelpOverlay w = this.addOverlay(caption, text, style);
        w.center();
        if (this.ui != null) {
            this.ui.addWindow((Window)w);
        }
    }

    protected HelpOverlay addOverlay(String caption, String text, String style) {
        HelpOverlay o = new HelpOverlay();
        o.setCaption(caption);
        if (text != null) {
            o.addComponent((Component)new Label(text, ContentMode.HTML));
        }
        if (style != null) {
            o.setStyleName(style);
        }
        this.overlays.add(o);
        return o;
    }
}

