/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.operation;

import com.vaadin.ui.Component;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.definition.DefRoot;
import de.mhus.lib.core.util.MNlsBundle;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.MutableMForm;
import de.mhus.lib.form.PropertiesDataSource;
import de.mhus.lib.vaadin.form.VaadinForm;
import de.mhus.lib.vaadin.operation.AbstractVaadinOperation;
import de.mhus.lib.vaadin.operation.AbstractVaadinOperationEditor;
import java.util.Map;

public abstract class AbstractVaadinOperationForm
extends AbstractVaadinOperationEditor {
    private static final long serialVersionUID = 1L;
    protected AbstractVaadinOperation operation;
    protected VaadinForm model;
    private PropertiesDataSource dataSource;

    public AbstractVaadinOperationForm(AbstractVaadinOperation operation) {
        this.operation = operation;
    }

    @Override
    protected void initUI() {
        this.model = this.createForm();
        this.model.setShowInformation(true);
        if (this.model.getForm().getNlsBundle() == null && this.model.getForm() instanceof MutableMForm) {
            ((MutableMForm)this.model.getForm()).setNlsBundle(MNlsBundle.lookup((Object)((Object)this)));
        }
        try {
            this.model.doBuild();
            this.addComponent((Component)this.model);
        }
        catch (Exception e) {
            log.e(new Object[]{e});
        }
    }

    protected VaadinForm createForm() {
        try {
            DefRoot formDef = this.operation.getDescription().getForm();
            VaadinForm form = new VaadinForm();
            form.setForm(new MutableMForm(formDef));
            this.dataSource = new PropertiesDataSource();
            this.initDataSource(this.dataSource);
            if (this.dataSource.getProperties() == null) {
                this.dataSource.setProperties(new MProperties());
            }
            ((MutableMForm)form.getForm()).setDataSource((DataSource)this.dataSource);
            return form;
        }
        catch (Throwable t) {
            log.w(new Object[]{t});
            return null;
        }
    }

    protected abstract void initDataSource(PropertiesDataSource var1);

    @Override
    public void fillOperationParameters(IProperties param) {
        param.putAll((Map)this.dataSource.getProperties());
    }
}

