/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.login;

import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.security.AccessControl;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import java.io.Serializable;
import javax.security.auth.Subject;

public class LoginScreen
extends CssLayout
implements MNlsProvider {
    private static final long serialVersionUID = 1L;
    private TextField username;
    private PasswordField password;
    private Button login;
    private LoginListener loginListener;
    private AccessControl accessControl;
    private MNls nls;

    public LoginScreen(AccessControl accessControl, LoginListener loginListener) {
        this.loginListener = loginListener;
        this.accessControl = accessControl;
        this.buildUI();
        this.username.focus();
    }

    private void buildUI() {
        this.addStyleName("login-screen");
        Component loginForm = this.buildLoginForm();
        VerticalLayout centeringLayout = new VerticalLayout();
        centeringLayout.setStyleName("centering-layout");
        centeringLayout.addComponent(loginForm);
        centeringLayout.setComponentAlignment(loginForm, Alignment.MIDDLE_CENTER);
        CssLayout loginInformation = this.buildLoginInformation();
        this.addComponent((Component)centeringLayout);
        this.addComponent((Component)loginInformation);
    }

    private Component buildLoginForm() {
        FormLayout loginForm = new FormLayout();
        loginForm.addStyleName("login-form");
        loginForm.setSizeUndefined();
        loginForm.setMargin(false);
        this.username = new TextField(MNls.find((MNlsProvider)this, (String)"login.username=Username"), "");
        loginForm.addComponent((Component)this.username);
        this.username.setWidth(15.0f, Sizeable.Unit.EM);
        this.password = new PasswordField(MNls.find((MNlsProvider)this, (String)"login.password=Password"));
        loginForm.addComponent((Component)this.password);
        this.password.setWidth(15.0f, Sizeable.Unit.EM);
        this.password.setDescription(MNls.find((MNlsProvider)this, (String)"login.password.description=Your password"));
        CssLayout buttons = new CssLayout();
        buttons.setStyleName("buttons");
        loginForm.addComponent((Component)buttons);
        this.login = new Button(MNls.find((MNlsProvider)this, (String)"login.signin=Sign In"));
        buttons.addComponent((Component)this.login);
        this.login.setDisableOnClick(true);
        this.login.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    LoginScreen.this.login();
                }
                finally {
                    LoginScreen.this.login.setEnabled(true);
                }
            }
        });
        this.login.setClickShortcut(13, new int[0]);
        this.login.addStyleName("friendly");
        return loginForm;
    }

    private CssLayout buildLoginInformation() {
        CssLayout loginInformation = new CssLayout();
        loginInformation.setStyleName("login-information");
        Label loginInfoText = new Label(MNls.find((MNlsProvider)this, (String)"login.info.text=Content Editor"), ContentMode.HTML);
        loginInformation.addComponent((Component)loginInfoText);
        return loginInformation;
    }

    private void login() {
        if (this.accessControl.signIn((String)this.username.getValue(), (String)this.password.getValue())) {
            Subject subject = (Subject)UI.getCurrent().getSession().getAttribute("_subject");
            if (subject == null) {
                MLogUtil.log().i(new Object[]{"no subject"});
            } else {
                MLogUtil.log().i(new Object[]{"Login", subject});
            }
            this.loginListener.loginSuccessful();
            return;
        }
        this.showNotification(new Notification(MNls.find((MNlsProvider)this, (String)"login.error.title=Login failed"), MNls.find((MNlsProvider)this, (String)"login.error.text=Please check your username and password and try again."), Notification.Type.HUMANIZED_MESSAGE));
        this.username.focus();
    }

    private void showNotification(Notification notification) {
        notification.setDelayMsec(2000);
        notification.show(Page.getCurrent());
    }

    public MNls getNls() {
        if (this.nls == null) {
            this.nls = MNls.lookup((Object)((Object)this));
        }
        return this.nls;
    }

    public static interface LoginListener
    extends Serializable {
        public void loginSuccessful();
    }
}

