/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.data.Property;
import com.vaadin.event.FieldEvents;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Component;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiLayout;

public abstract class UiVaadin
extends UiComponent {
    private Component componentWizard;
    private Component componentError;
    private Component componentLabel;
    private Component componentEditor;
    private boolean editorEditable = true;

    public void doRevert() throws MException {
        DataSource ds = this.getForm().getDataSource();
        this.setEnabled(ds.getBoolean((UiComponent)this, "enabled", true));
        this.setEditable(ds.getBoolean((UiComponent)this, "enabled", true));
        this.setVisible(ds.getBoolean((UiComponent)this, "visible", true));
        this.doUpdateMetadata();
        Object val = this.getConfig().get((Object)"value");
        if (val == null) {
            val = this.getConfig().getString("defaultvalue", null);
        }
        this.setValue(ds.getObject((UiComponent)this, "", val));
        this.setCaption(this.getCaption(ds));
        if (this.componentError != null) {
            this.componentError.setVisible(false);
        }
        boolean bl = this.editorEditable = this.getConfig().getBoolean("editable", true) && ds.getBoolean((UiComponent)this, "editable", true);
        if (this.componentEditor != null && !this.editorEditable) {
            this.componentEditor.setEnabled(false);
        }
        this.getForm().getControl().reverted((UiComponent)this);
    }

    public String getCaption(DataSource ds) {
        return MNls.find((MNlsProvider)this.getForm(), (String)ds.getString((UiComponent)this, "caption", this.getConfigString("caption", this.getName())));
    }

    public void doUpdateValue() throws MException {
        DataSource ds = this.getForm().getDataSource();
        String def = this.getConfig().getString("defaultvalue", null);
        this.setValue(ds.getObject((UiComponent)this, "", (Object)def));
        this.getForm().getControl().valueSet((UiComponent)this);
    }

    public void setVisible(boolean visible) throws MException {
        if (this.componentLabel != null) {
            this.componentLabel.setVisible(visible);
        }
        if (this.componentError != null && this.componentError.isVisible()) {
            this.componentError.setVisible(visible);
        }
        if (this.componentEditor != null) {
            this.componentEditor.setVisible(visible);
        }
        if (this.componentWizard != null) {
            this.componentWizard.setVisible(visible);
        }
    }

    public boolean isVisible() throws MException {
        if (this.componentLabel != null && this.componentLabel.isVisible()) {
            return true;
        }
        if (this.componentError != null && this.componentError.isVisible()) {
            return true;
        }
        if (this.componentEditor != null && this.componentEditor.isVisible()) {
            return true;
        }
        return this.componentWizard != null && this.componentWizard.isVisible();
    }

    public void setEnabled(boolean enabled) throws MException {
        if (this.componentEditor != null && this.editorEditable) {
            this.componentEditor.setEnabled(enabled);
        }
        if (this.componentWizard != null) {
            this.componentWizard.setEnabled(enabled);
        }
    }

    public boolean isEnabled() throws MException {
        if (this.componentEditor != null && this.componentEditor.isVisible()) {
            return true;
        }
        return this.componentWizard != null && this.componentWizard.isVisible();
    }

    public void setEditable(boolean editable) throws MException {
        if (this.componentEditor != null && this.editorEditable) {
            this.componentEditor.setReadOnly(!editable);
        }
    }

    protected abstract void setValue(Object var1) throws MException;

    protected abstract Object getValue() throws MException;

    protected void setCaption(String value) throws MException {
        if (this.componentLabel != null) {
            this.componentLabel.setCaption(value);
        }
    }

    protected Component create(UiLayout grid) throws MException {
        grid.createRow(this);
        return this.getComponentEditor();
    }

    public abstract Component createEditor();

    public Component getComponentWizard() {
        return this.componentWizard;
    }

    public void setComponentWizard(Component componentWizard) {
        this.componentWizard = componentWizard;
    }

    public Component getComponentError() {
        return this.componentError;
    }

    public void setComponentError(Component componentError) {
        this.componentError = componentError;
    }

    public Component getComponentLabel() {
        return this.componentLabel;
    }

    public void setComponentLabel(Component componentLabel) {
        this.componentLabel = componentLabel;
    }

    public Component getComponentEditor() {
        return this.componentEditor;
    }

    public void setComponentEditor(Component componentEditor) {
        this.componentEditor = componentEditor;
    }

    public UiLayout getLayout() {
        return null;
    }

    public void setError(String error) {
        Component el = this.getComponentError();
        if (el == null) {
            return;
        }
        el.setCaption(error);
        el.setVisible(true);
    }

    public void clearError() {
        Component el = this.getComponentError();
        if (el == null) {
            return;
        }
        el.setCaption("");
        el.setVisible(false);
    }

    public void fieldValueChangedEvent() {
        Component e = this.getComponentEditor();
        DataSource ds = this.getForm().getDataSource();
        if (e == null || ds == null) {
            return;
        }
        Object newValue = null;
        try {
            newValue = this.getValue();
            if (this.getForm().getControl().newValue((UiComponent)this, newValue)) {
                ds.setObject((UiComponent)this, "", newValue);
            }
        }
        catch (Throwable t) {
            this.getForm().getControl().newValueError((UiComponent)this, newValue, t);
        }
    }

    public void focusEvent() {
        this.getForm().getControl().focus((UiComponent)this);
    }

    public void setListeners() {
        Component e = this.getComponentEditor();
        if (e == null) {
            return;
        }
        if (e instanceof AbstractField) {
            ((AbstractField)e).setImmediate(true);
            ((AbstractField)e).addValueChangeListener(new Property.ValueChangeListener(){
                private static final long serialVersionUID = 1L;

                public void valueChange(Property.ValueChangeEvent event) {
                    UiVaadin.this.fieldValueChangedEvent();
                }
            });
        }
        if (e instanceof FieldEvents.FocusNotifier) {
            ((FieldEvents.FocusNotifier)e).addFocusListener(new FieldEvents.FocusListener(){
                private static final long serialVersionUID = 1L;

                public void focus(FieldEvents.FocusEvent event) {
                    UiVaadin.this.focusEvent();
                }
            });
        }
    }

    public void doUpdateMetadata() throws MException {
    }
}

