/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;
import java.io.Serializable;
import java.util.LinkedList;

public class UiLayoutWizard
extends UiLayout {
    private static final long serialVersionUID = 1L;
    private TabSheet layout;
    private LinkedList<UiVaadin> tabIndex = new LinkedList();

    public UiLayoutWizard() {
        this.layout = new TabSheet();
        this.layout.setWidth("100%");
    }

    @Override
    public void createRow(UiVaadin c) {
        this.tabIndex.add(c);
        int current = this.tabIndex.size();
        Component editor = c.createEditor();
        DataSource ds = this.getForm().getDataSource();
        String caption = c.getCaption(ds);
        VerticalLayout iEditor = new VerticalLayout();
        iEditor.addComponent(editor);
        iEditor.setExpandRatio(editor, 1.0f);
        HorizontalLayout toolBar = new HorizontalLayout();
        Button bBack = new Button((Resource)FontAwesome.ARROW_LEFT);
        bBack.addClickListener((Button.ClickListener & Serializable)e -> {
            if (current < 1) {
                return;
            }
            this.layout.setSelectedTab(current - 2);
        });
        toolBar.addComponent((Component)bBack);
        toolBar.setExpandRatio((Component)bBack, 0.0f);
        Label spacer = new Label();
        toolBar.addComponent((Component)spacer);
        toolBar.setExpandRatio((Component)spacer, 1.0f);
        Button bNext = new Button((Resource)FontAwesome.ARROW_RIGHT);
        bNext.addClickListener((Button.ClickListener & Serializable)e -> {
            if (current >= this.tabIndex.size()) {
                return;
            }
            this.layout.setSelectedTab(current);
        });
        toolBar.addComponent((Component)bNext);
        toolBar.setExpandRatio((Component)bNext, 0.0f);
        toolBar.setWidth("100%");
        iEditor.addComponent((Component)toolBar);
        iEditor.setExpandRatio((Component)toolBar, 0.0f);
        iEditor.setSizeFull();
        this.layout.addTab((Component)iEditor, caption);
    }

    @Override
    public void doRevert() throws MException {
        for (UiVaadin entry : this.tabIndex) {
            try {
                entry.doRevert();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        super.doRevert();
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiLayoutWizard();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

