/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;
import java.util.LinkedList;

public class UiLayoutTabs
extends UiLayout {
    private static final long serialVersionUID = 1L;
    private TabSheet layout;
    private LinkedList<UiVaadin> tabIndex = new LinkedList();

    public UiLayoutTabs() {
        this.layout = new TabSheet();
        this.layout.setWidth("100%");
    }

    @Override
    public void createRow(UiVaadin c) {
        this.tabIndex.add(c);
        Component editor = c.createEditor();
        DataSource ds = this.getForm().getDataSource();
        String caption = c.getCaption(ds);
        this.layout.addTab(editor, caption);
    }

    @Override
    public void doRevert() throws MException {
        for (UiVaadin entry : this.tabIndex) {
            try {
                entry.doRevert();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        super.doRevert();
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiLayoutTabs();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

