/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.IndexedContainer;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.vaadin.ColumnDefinition;
import de.mhus.lib.vaadin.ExpandingTable;
import java.util.LinkedList;

public class SimpleTable
extends ExpandingTable {
    private static final long serialVersionUID = 1L;
    private IndexedContainer dataSource;
    private ColumnDefinition[] columns;

    public SimpleTable() {
    }

    public SimpleTable(String caption, Container dataSource) {
        super(caption, dataSource);
    }

    public SimpleTable(String caption) {
        super(caption);
    }

    @Override
    protected void initUI() {
        this.setColumnReorderingAllowed(true);
        this.setColumnCollapsingAllowed(true);
        this.setSizeFull();
        super.initUI();
    }

    public void createDataSource(ColumnDefinition ... columns) {
        this.columns = columns;
        this.dataSource = new IndexedContainer();
        LinkedList<String> columnList = new LinkedList<String>();
        LinkedList<String> colapsedByDefault = new LinkedList<String>();
        for (ColumnDefinition column : columns) {
            this.dataSource.addContainerProperty((Object)column.getId(), column.getType(), column.getDefaultValue());
            this.setColumnHeader(column.getId(), column.getTitle());
            if (!column.isShowByDefault()) {
                colapsedByDefault.add(column.getId());
            }
            columnList.add(column.getId());
        }
        this.setContainerDataSource((Container)this.dataSource);
        this.setVisibleColumns(columnList.toArray(new Object[colapsedByDefault.size()]));
        for (Object e : colapsedByDefault) {
            this.setColumnCollapsed(e, true);
        }
    }

    public IndexedContainer getDataSource() {
        return this.dataSource;
    }

    public ColumnDefinition[] getColumns() {
        return this.columns;
    }

    public void addRow(Object id, Object ... values) {
        if (id == null) {
            MLogUtil.log().i(new Object[]{((Object)((Object)this)).getClass(), "addRow: id is null"});
            return;
        }
        Item item = this.dataSource.addItem(id);
        if (item == null) {
            MLogUtil.log().i(new Object[]{((Object)((Object)this)).getClass(), "addRow: item is null", id});
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) {
                MLogUtil.log().i(new Object[]{((Object)((Object)this)).getClass(), "addRow: column is null", i});
                return;
            }
            item.getItemProperty((Object)this.columns[i].getId()).setValue(values.length > i ? values[i] : this.columns[i].getDefaultValue());
        }
    }

    public boolean updateRow(Object id, Object[] values) {
        Item item = this.dataSource.getItem(id);
        if (item == null) {
            return false;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            item.getItemProperty((Object)this.columns[i].getId()).setValue(values.length > i ? values[i] : this.columns[i].getDefaultValue());
        }
        return true;
    }

    public void removeRow(Object id) {
        this.dataSource.removeItem(id);
    }
}

