/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.vaadin.ModalDialog;

public class ConfirmDialog
extends ModalDialog {
    private static final long serialVersionUID = 1L;
    private ModalDialog.Action confirm;
    private ModalDialog.Action cancel;
    private String message;
    private ModalDialog.Action result;
    private Listener listener;
    protected Label label;

    public ConfirmDialog(String title, String message, String txtConfirm, String txtCancel, Listener listener) throws Exception {
        this.message = message;
        this.listener = listener;
        this.confirm = new ModalDialog.Action("confirm", txtConfirm);
        this.confirm.setDefaultAction(true);
        this.cancel = new ModalDialog.Action("cancel", txtCancel);
        this.actions = new ModalDialog.Action[]{this.confirm, this.cancel};
        this.setPack(true);
        this.initUI();
        this.setCaption(title);
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    protected void initContent(VerticalLayout layout) throws Exception {
        this.label = new Label(this.message);
        this.label.setContentMode(Label.CONTENT_XHTML);
        layout.addComponent((Component)this.label);
    }

    @Override
    protected boolean doAction(ModalDialog.Action action) {
        this.result = action;
        if (this.listener != null) {
            this.listener.onClose(this);
        }
        return true;
    }

    public static void show(UI ui, String title, String message, String txtConfirm, String txtCancel, Listener listener) {
        try {
            new ConfirmDialog(title, message, txtConfirm, txtCancel, listener).show(ui);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConfirmed() {
        return this.result == this.confirm;
    }

    public boolean isCancel() {
        return this.result == this.cancel;
    }

    public static interface Listener {
        public void onClose(ConfirmDialog var1);
    }
}

