/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.util.converter.Converter;
import com.vaadin.ui.Table;
import de.mhus.lib.annotations.vaadin.Column;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.vaadin.MhuTable;
import de.mhus.lib.vaadin.converter.ObjectConverter;

public class ColumnModel {
    private Table table;
    private String colId;
    private boolean editable = true;
    private Class<?> converter;

    public ColumnModel(Table table, String colId) {
        this.table = table;
        this.colId = colId;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getPropertyId() {
        return this.colId;
    }

    public Table getTable() {
        return this.table;
    }

    public void setCollapsed(boolean collapsed) {
        this.table.setColumnCollapsed((Object)this.colId, collapsed);
    }

    public Class<?> getConverter() {
        return this.converter;
    }

    public void setConverter(Class<?> converter) {
        this.converter = converter == Object.class ? null : converter;
    }

    public Converter<String, ?> generateConverter(Class<?> type) {
        try {
            if (this.converter != null) {
                return (Converter)this.converter.newInstance();
            }
            this.converter = MhuTable.findDefaultConverter(this, type);
            if (this.converter != null) {
                return (Converter)this.converter.newInstance();
            }
        }
        catch (Throwable t) {
            MLogUtil.log().d(new Object[]{t});
        }
        return new ObjectConverter();
    }

    public void configureByAnnotation(Column columnDef, boolean canWrite) {
        this.setEditable(columnDef.editable() && canWrite);
        this.setConverter(columnDef.converter());
    }
}

