/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;
import java.util.HashMap;
import java.util.Map;

public class VaadinFormBuilder {
    private MForm form;
    private UiLayout layout;
    private HashMap<String, UiVaadin> index = new HashMap();

    public void doBuild() throws Exception {
        this.index.clear();
        IConfig model = this.form.getModel();
        this.layout = this.createLayout(model);
        this.build(this.layout, model);
    }

    public UiLayout createLayout(IConfig model) throws Exception {
        String name = "layout" + model.getString("layout", "100");
        UiLayout ret = (UiLayout)this.form.getAdapterProvider().createComponent(name, model);
        ret.doInit(this.form, model);
        return ret;
    }

    private void build(UiLayout layout, IConfig model) throws Exception {
        for (ResourceNode node : model.getNodes()) {
            String name = node.getName();
            if (name.equals("element")) {
                name = node.getString("type");
            }
            UiComponent comp = this.form.getAdapterProvider().createComponent(name, (IConfig)node);
            comp.doInit(this.form, (IConfig)node);
            layout.createRow((UiVaadin)comp);
            this.index.put(node.getString("name"), (UiVaadin)comp);
            UiLayout nextLayout = ((UiVaadin)comp).getLayout();
            if (nextLayout == null) continue;
            this.build(nextLayout, (IConfig)node);
        }
    }

    public void doRevert() {
        try {
            this.layout.doRevert();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, UiVaadin> entry : this.index.entrySet()) {
            try {
                entry.getValue().doRevert();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void doUpdateValues() {
        for (Map.Entry<String, UiVaadin> entry : this.index.entrySet()) {
            try {
                entry.getValue().doUpdateValue();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public UiVaadin getComponent(String name) {
        return this.index.get(name);
    }

    public UiLayout getLayout() {
        return this.layout;
    }

    public MForm getForm() {
        return this.form;
    }

    public void setForm(MForm form) {
        this.form = form;
    }
}

