/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import de.mhus.lib.form.ActivatorAdapterProvider;
import de.mhus.lib.form.ComponentAdapterProvider;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.UiInformation;
import de.mhus.lib.vaadin.form.DefaultAdapterProvider;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.VaadinFormBuilder;
import de.mhus.lib.vaadin.form.VaadinUiInformation;

public class VaadinForm
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private VaadinFormBuilder builder;
    private MForm form;
    private SHOW showInformation = SHOW.MODEL;
    private VaadinUiInformation informationPane;
    private UiLayout layout;
    private Panel formPanel;

    public VaadinForm() {
    }

    public VaadinForm(MForm form) {
        this.setForm(form);
    }

    public void doBuild(MActivator activator) throws Exception {
        if (activator != null) {
            this.form.setAdapterProvider((ComponentAdapterProvider)new ActivatorAdapterProvider(activator));
        }
        this.doBuild();
    }

    public void doBuild() throws Exception {
        if (this.form.getAdapterProvider() == null) {
            this.form.setAdapterProvider((ComponentAdapterProvider)MApi.lookup(ActivatorAdapterProvider.class, DefaultAdapterProvider.class));
        }
        if (this.isShowInformation()) {
            this.informationPane = new VaadinUiInformation();
            this.getForm().setInformationPane((UiInformation)this.informationPane);
            this.addComponent((Component)this.informationPane);
            this.setExpandRatio((Component)this.informationPane, 0.0f);
            this.informationPane.setHeight("100px");
            this.informationPane.setWidth("100%");
        }
        if (this.builder == null) {
            this.builder = new VaadinFormBuilder();
        }
        this.builder.setForm(this.form);
        this.builder.doBuild();
        this.builder.doRevert();
        this.formPanel = new Panel();
        this.formPanel.setWidth("100%");
        this.formPanel.setHeight("100%");
        this.layout = this.builder.getLayout();
        this.formPanel.setContent(this.layout.getComponent());
        this.addComponent((Component)this.formPanel);
        this.setExpandRatio((Component)this.formPanel, 1.0f);
    }

    public boolean isShowInformation() {
        return this.showInformation == SHOW.YES || this.showInformation == SHOW.MODEL && this.form != null && this.form.getModel() != null && this.form.getModel().getBoolean("showInformation", false);
    }

    public void setShowInformation(boolean showInformation) {
        this.showInformation = showInformation ? SHOW.YES : SHOW.NO;
    }

    public void setShowInformation(SHOW showInformation) {
        this.showInformation = showInformation;
    }

    public SHOW getShowInformation() {
        return this.showInformation;
    }

    public VaadinFormBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(VaadinFormBuilder builder) {
        this.builder = builder;
    }

    public MForm getForm() {
        return this.form;
    }

    public void setForm(MForm form) {
        this.form = form;
    }

    public static enum SHOW {
        MODEL,
        YES,
        NO;

    }
}

