/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.DataSource;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;

public class UiPanel
extends UiLayout {
    private static final long serialVersionUID = 1L;
    private Panel layout = new Panel();
    private UiVaadin content = null;

    public UiPanel() {
        this.layout.setWidth("100%");
    }

    @Override
    public void createRow(UiVaadin c) {
        Component editor = c.createEditor();
        DataSource ds = this.getForm().getDataSource();
        String caption = c.getCaption(ds);
        this.layout.setCaption(caption);
        if (editor instanceof Layout) {
            this.layout.setContent(editor);
        } else {
            VerticalLayout container = new VerticalLayout(new Component[]{editor});
            this.layout.setContent((Component)container);
            c.setComponentEditor(editor);
            c.setListeners();
        }
        editor.setWidth("100%");
        this.content = c;
    }

    @Override
    public void doRevert() throws MException {
        try {
            this.content.doRevert();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.doRevert();
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiPanel();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

