/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.form.UiWizard;
import de.mhus.lib.vaadin.form.UiLayout;
import de.mhus.lib.vaadin.form.UiVaadin;

public class UiLayout50x50
extends UiLayout {
    private static final long serialVersionUID = 1L;
    private GridLayout layout = new GridLayout(6, 1);
    private int rows;
    private UiSlot slot;

    public UiLayout50x50() {
        this.layout.setMargin(true);
        this.layout.setSpacing(true);
        this.layout.setHideEmptyRowsAndColumns(true);
        this.layout.setColumnExpandRatio(0, 0.3f);
        this.layout.setColumnExpandRatio(1, 0.7f);
        this.layout.setColumnExpandRatio(2, 0.0f);
        this.layout.setColumnExpandRatio(3, 0.3f);
        this.layout.setColumnExpandRatio(4, 0.7f);
        this.layout.setColumnExpandRatio(5, 0.0f);
        this.layout.setWidth("100%");
        this.rows = 0;
    }

    @Override
    public void createRow(UiVaadin c) {
        UiWizard wizard = c.getWizard();
        Component e = c.createEditor();
        if (e == null) {
            return;
        }
        c.setComponentEditor(e);
        e.setWidth("100%");
        c.setListeners();
        if (this.slot == null) {
            this.slot = new UiSlot();
        } else if (c.getConfig().getInt("columns", 1) > 1) {
            this.slot = new UiSlot();
        }
        this.slot.add(c, wizard, e);
        if (this.slot.isFull()) {
            this.slot = null;
        }
    }

    protected UiRow createRow(int col, int size, int row) {
        return new UiRow(this.layout, col, row, size);
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiLayout50x50();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }

    private class UiSlot {
        private int startRow;
        private int col;

        public UiSlot() {
            this.startRow = UiLayout50x50.this.rows;
            UiLayout50x50.this.rows = UiLayout50x50.this.rows + 3;
            UiLayout50x50.this.layout.setRows(UiLayout50x50.this.rows);
            this.col = 0;
        }

        public void add(final UiVaadin c, final UiWizard wizard, Component e) {
            Label l;
            int size = 2;
            if (c.getConfig().getInt("columns", 1) > 1) {
                size = 5;
            }
            UiRow row1 = UiLayout50x50.this.createRow(this.col, size, this.startRow);
            UiRow row2 = UiLayout50x50.this.createRow(this.col, size, this.startRow + 1);
            UiRow row3 = UiLayout50x50.this.createRow(this.col, size, this.startRow + 2);
            if (c.isFullSize()) {
                row1.setFull(true);
                l = new Label();
                l.setStyleName("form-label");
                l.setWidth("100%");
                c.setComponentLabel((Component)l);
                row1.setComponent((Component)l);
                row2.setFull(true);
                if (wizard != null) {
                    Button b = new Button();
                    b.setIcon((Resource)FontAwesome.COG);
                    b.addClickListener(new Button.ClickListener(){
                        private static final long serialVersionUID = 1L;

                        public void buttonClick(Button.ClickEvent event) {
                            wizard.showWizard((UiComponent)c);
                        }
                    });
                    b.setWidth("100%");
                    row2.setWizard((Component)b);
                    c.setComponentWizard((Component)b);
                }
                row2.setComponent(e);
            } else {
                l = new Label();
                l.setWidth("100%");
                c.setComponentLabel((Component)l);
                row1.setLeft((Component)l);
                if (wizard != null) {
                    Button b = new Button("W");
                    b.addClickListener(new Button.ClickListener(){
                        private static final long serialVersionUID = 1L;

                        public void buttonClick(Button.ClickEvent event) {
                            wizard.showWizard((UiComponent)c);
                        }
                    });
                    b.setWidth("100%");
                    row1.setWizard((Component)b);
                    c.setComponentWizard((Component)b);
                }
                row1.setRight(e);
            }
            row3.setFull(c.isFullSize());
            Label le = new Label();
            le.setStyleName("error-text");
            le.setWidth("100%");
            c.setComponentError((Component)le);
            row3.setComponent((Component)le);
            this.col += 1 + size;
        }

        public boolean isFull() {
            return this.col >= 6;
        }
    }

    public class UiRow {
        private GridLayout layout;
        private int row;
        private boolean full;
        private boolean wizard;
        private int col;
        private int size;

        public UiRow(GridLayout layout, int col, int row, int size) {
            this.layout = layout;
            this.row = row;
            this.col = col;
            this.size = size;
        }

        public void setLeft(Component component) {
            if (this.full) {
                return;
            }
            this.layout.addComponent(component, this.col, this.row);
        }

        public void setRight(Component component) {
            if (this.full) {
                return;
            }
            if (this.wizard) {
                this.layout.addComponent(component, this.col + 1, this.row, this.col + this.size - 1, this.row);
            } else {
                this.layout.addComponent(component, this.col + 1, this.row, this.col + this.size, this.row);
            }
        }

        public void setComponent(Component component) {
            if (!this.full) {
                this.setRight(component);
                return;
            }
            if (this.wizard) {
                this.layout.addComponent(component, 0, this.row, this.col + this.size - 1, this.row);
            } else {
                this.layout.addComponent(component, 0, this.row, this.col + this.size, this.row);
            }
        }

        public boolean isFull() {
            return this.full;
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public boolean isWizard() {
            return this.wizard;
        }

        public void setWizard(Component wizard) {
            boolean bl = this.wizard = wizard != null;
            if (wizard == null) {
                return;
            }
            this.layout.addComponent(wizard, this.col + this.size, this.row);
        }
    }
}

