/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form;

import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.ui.Component;
import com.vaadin.ui.DateField;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.ComponentAdapter;
import de.mhus.lib.form.ComponentDefinition;
import de.mhus.lib.form.UiComponent;
import de.mhus.lib.form.definition.FmDate;
import de.mhus.lib.vaadin.form.UiVaadin;

public class UiDate
extends UiVaadin {
    @Override
    protected void setValue(Object value) throws MException {
        ((DateField)this.getComponentEditor()).setValue((Object)MCast.toDate((Object)value, null));
    }

    @Override
    public Component createEditor() {
        DateField ret = new DateField();
        ret.setLocale(this.getForm().getLocale());
        FmDate.FORMATS format = FmDate.FORMATS.valueOf((String)this.getConfig().getString("format", FmDate.FORMATS.DATE.name()).toUpperCase());
        switch (format) {
            case DATE: {
                ret.setResolution(Resolution.DAY);
                break;
            }
            case DATETIME: {
                ret.setResolution(Resolution.MINUTE);
                break;
            }
            case DATETIMESECONDS: {
                ret.setResolution(Resolution.SECOND);
                break;
            }
            case TIME: {
                ret.setDateFormat("HH:mm");
                ret.setResolution(Resolution.MINUTE);
                break;
            }
            case TIMESECONDS: {
                ret.setDateFormat("HH:mm:ss");
                ret.setResolution(Resolution.SECOND);
                break;
            }
        }
        return ret;
    }

    @Override
    protected Object getValue() throws MException {
        return ((DateField)this.getComponentEditor()).getValue();
    }

    public static class Adapter
    implements ComponentAdapter {
        public UiComponent createAdapter(IConfig config) {
            return new UiDate();
        }

        public ComponentDefinition getDefinition() {
            return null;
        }
    }
}

