/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import de.mhus.lib.core.util.Pair;
import java.util.List;
import java.util.UUID;

public abstract class VWorkBar
extends HorizontalLayout {
    private static final long serialVersionUID = 1L;
    private Button bDelete;
    private Button bModify;
    private Button bAdd;
    private Label tStatus;
    private ComboBox menuDelete = new ComboBox();
    private ComboBox menuModify;
    private ComboBox menuAdd;

    public VWorkBar() {
        this.menuDelete.setTextInputAllowed(false);
        this.menuDelete.setId("a" + UUID.randomUUID().toString().replace('-', 'x'));
        this.menuDelete.setWidth("0px");
        this.menuDelete.setNullSelectionAllowed(false);
        this.menuDelete.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                VWorkBar.this.doMenuSelected();
            }
        });
        this.addComponent((Component)this.menuDelete);
        this.bDelete = new Button((Resource)FontAwesome.MINUS);
        this.addComponent((Component)this.bDelete);
        this.bDelete.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                VWorkBar.this.doDelete();
            }
        });
        this.menuModify = this.menuDelete;
        this.bModify = new Button((Resource)FontAwesome.COG);
        this.addComponent((Component)this.bModify);
        this.bModify.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                VWorkBar.this.doModify();
            }
        });
        this.menuAdd = this.menuDelete;
        this.bAdd = new Button((Resource)FontAwesome.PLUS);
        this.addComponent((Component)this.bAdd);
        this.bAdd.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                VWorkBar.this.doAdd();
            }
        });
        this.tStatus = new Label();
        this.addComponent((Component)this.tStatus);
        this.setExpandRatio((Component)this.tStatus, 1.0f);
    }

    public void setButtonStyleName(String style) {
        this.bAdd.setStyleName(style);
        this.bModify.setStyleName(style);
        this.bDelete.setStyleName(style);
    }

    protected void doMenuSelected() {
        Pair item = (Pair)this.menuDelete.getValue();
        if (item == null) {
            return;
        }
        Object[] val = (Object[])item.getValue();
        if (((String)val[0]).equals("add")) {
            this.doAdd(val[1]);
        } else if (((String)val[0]).equals("mod")) {
            this.doModify(val[1]);
        } else if (((String)val[0]).equals("del")) {
            this.doDelete(val[1]);
        }
    }

    protected void doAdd() {
        List<Pair<String, Object>> options = this.getAddOptions();
        if (options == null || options.size() <= 0) {
            return;
        }
        this.menuAdd.removeAllItems();
        for (Pair<String, Object> item : options) {
            Pair out = new Pair(item.getKey(), (Object)new Object[]{"add", item.getValue()});
            this.menuAdd.addItem((Object)out);
        }
        String myCode = "$('#" + this.menuAdd.getId() + "').find('input')[0].click();";
        Page.getCurrent().getJavaScript().execute(myCode);
    }

    public abstract List<Pair<String, Object>> getAddOptions();

    public abstract List<Pair<String, Object>> getModifyOptions();

    public abstract List<Pair<String, Object>> getDeleteOptions();

    protected void doModify() {
        List<Pair<String, Object>> options = this.getModifyOptions();
        if (options == null || options.size() <= 0) {
            return;
        }
        this.menuModify.removeAllItems();
        for (Pair<String, Object> item : options) {
            Pair out = new Pair(item.getKey(), (Object)new Object[]{"mod", item.getValue()});
            this.menuModify.addItem((Object)out);
        }
        String myCode = "$('#" + this.menuModify.getId() + "').find('input')[0].click();";
        Page.getCurrent().getJavaScript().execute(myCode);
    }

    protected void doDelete() {
        List<Pair<String, Object>> options = this.getDeleteOptions();
        if (options == null || options.size() <= 0) {
            return;
        }
        this.menuDelete.removeAllItems();
        for (Pair<String, Object> item : options) {
            Pair out = new Pair(item.getKey(), (Object)new Object[]{"del", item.getValue()});
            this.menuDelete.addItem((Object)out);
        }
        String myCode = "$('#" + this.menuDelete.getId() + "').find('input')[0].click();";
        Page.getCurrent().getJavaScript().execute(myCode);
    }

    protected abstract void doModify(Object var1);

    protected abstract void doDelete(Object var1);

    protected abstract void doAdd(Object var1);

    public void setStatus(String msg) {
        this.tStatus.setCaption(msg);
    }
}

