/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.event.ShortcutListener;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import de.mhus.lib.vaadin.ModalDialog;

public class PasswordInputDialog
extends ModalDialog {
    private static final long serialVersionUID = 1L;
    private String message;
    private Listener listener;
    private ModalDialog.Action confirm;
    private ModalDialog.Action cancel;
    protected Label label;
    private PasswordField textField;
    private String txtInput;
    private ModalDialog.Action result;

    public PasswordInputDialog(String title, String message, String txtInput, String txtConfirm, String txtCancel, Listener listener) throws Exception {
        this.message = message;
        this.listener = listener;
        this.txtInput = txtInput;
        this.confirm = new ModalDialog.Action("confirm", txtConfirm);
        this.cancel = new ModalDialog.Action("cancel", txtCancel);
        this.actions = new ModalDialog.Action[]{this.confirm, this.cancel};
        this.initUI();
        this.setCaption(title);
    }

    public Label getLabel() {
        return this.label;
    }

    public PasswordField getTextField() {
        return this.textField;
    }

    @Override
    protected void initContent(VerticalLayout layout) throws Exception {
        this.label = new Label(this.message);
        this.label.setContentMode(Label.CONTENT_XHTML);
        layout.addComponent((Component)this.label);
        this.textField = new PasswordField();
        this.textField.setValue(this.txtInput);
        this.textField.setWidth("100%");
        this.textField.focus();
        this.textField.addShortcutListener(new ShortcutListener("Confirm", 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                PasswordInputDialog.this.confirm.doAction(PasswordInputDialog.this);
            }
        });
        this.textField.setImmediate(true);
        layout.addComponent((Component)this.textField);
        this.txtInput = null;
    }

    @Override
    protected boolean doAction(ModalDialog.Action action) {
        this.result = action;
        if (action.equals(this.confirm)) {
            this.txtInput = (String)this.textField.getValue();
        }
        if (this.listener != null) {
            if (action.equals(this.confirm) && !this.listener.validate(this.txtInput)) {
                return false;
            }
            this.listener.onClose(this);
        }
        return true;
    }

    public static void show(UI parent, String title, String txtInput, String message, String txtConfirm, String txtCancel, Listener listener) {
        try {
            new PasswordInputDialog(title, message, txtInput, txtConfirm, txtCancel, listener).show(parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConfirmed() {
        return this.result == this.confirm;
    }

    public boolean isCancel() {
        return this.result == this.cancel;
    }

    public String getInputText() {
        return this.txtInput;
    }

    public static interface Listener {
        public boolean validate(String var1);

        public void onClose(PasswordInputDialog var1);
    }
}

