/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import com.vaadin.data.Container;
import com.vaadin.ui.Table;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MEventHandler;
import de.mhus.lib.core.MSystem;
import java.util.Map;

public class ExpandingTable
extends Table {
    private static final long serialVersionUID = 1L;
    private String sortedColumn;
    private boolean sortedAscending;
    private MEventHandler<RenderListener> renderEventHandler = new MEventHandler<RenderListener>(){

        public void onFire(RenderListener listener, Object event, Object ... values) {
            listener.onRender(ExpandingTable.this, (Integer)values[0], (Integer)values[1]);
        }
    };
    private MEventHandler<SortListener> sortEventHandler = new MEventHandler<SortListener>(){

        public void onFire(SortListener listener, Object event, Object ... values) {
            listener.onSortChanged(ExpandingTable.this);
        }
    };

    public ExpandingTable() {
        this.initUI();
    }

    public ExpandingTable(String caption, Container dataSource) {
        super(caption, dataSource);
        this.initUI();
    }

    public ExpandingTable(String caption) {
        super(caption);
        this.initUI();
    }

    protected void initUI() {
        this.addHeaderClickListener(new Table.HeaderClickListener(){
            private static final long serialVersionUID = 1L;

            public void headerClick(Table.HeaderClickEvent event) {
                if (ExpandingTable.super.isSortDisabled()) {
                    return;
                }
                String name = String.valueOf(event.getPropertyId());
                if (name.equals(ExpandingTable.this.sortedColumn)) {
                    ExpandingTable.this.sortedAscending = !ExpandingTable.this.sortedAscending;
                } else {
                    ExpandingTable.this.sortedAscending = true;
                }
                ExpandingTable.this.sortedColumn = name;
                boolean changed = false;
                if (!MSystem.equals((Object)ExpandingTable.super.getSortContainerPropertyId(), (Object)ExpandingTable.this.sortedColumn)) {
                    ExpandingTable.super.setSortContainerPropertyId(ExpandingTable.this.sortedColumn);
                    changed = true;
                }
                if (ExpandingTable.super.isSortAscending() != ExpandingTable.this.sortedAscending) {
                    ExpandingTable.super.setSortAscending(ExpandingTable.this.sortedAscending);
                    changed = true;
                }
                if (changed) {
                    ExpandingTable.this.sortEventHandler.fire();
                }
            }
        });
    }

    public void changeVariables(Object source, Map variables) {
        super.changeVariables(source, variables);
        if (variables.containsKey("lastToBeRendered")) {
            int last = MCast.toint(variables.get("lastToBeRendered"), (int)-1);
            int first = MCast.toint(variables.get("firstToBeRendered"), (int)-1);
            if (last >= 0) {
                this.renderEventHandler.fire(null, new Object[]{first, last});
            }
        }
    }

    public MEventHandler<RenderListener> renderEventHandler() {
        return this.renderEventHandler;
    }

    public MEventHandler<SortListener> sortEventHandler() {
        return this.sortEventHandler;
    }

    public void setSortContainerPropertyId(Object propertyId) {
        this.sortedColumn = String.valueOf(propertyId);
        super.setSortContainerPropertyId(propertyId);
        this.sortEventHandler.fire();
    }

    public void setSortAscending(boolean ascending) {
        this.sortedAscending = ascending;
        super.setSortAscending(ascending);
        this.sortEventHandler.fire();
    }

    public void setSortDisabled(boolean sortDisabled) {
        if (sortDisabled != super.isSortDisabled()) {
            this.sortedColumn = null;
            this.sortedAscending = true;
            super.setSortDisabled(sortDisabled);
            this.sortEventHandler.fire();
        }
    }

    public String getSortedColumn() {
        return this.sortedColumn;
    }

    public boolean isSortedAscending() {
        return this.sortedAscending;
    }

    public static interface SortListener {
        public void onSortChanged(ExpandingTable var1);
    }

    public static interface RenderListener {
        public void onRender(ExpandingTable var1, int var2, int var3);
    }
}

