/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin;

import de.mhus.lib.annotations.vaadin.Column;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.util.FilterRequest;
import de.mhus.lib.core.util.MNls;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.vaadin.AbstractListEditor;
import de.mhus.lib.vaadin.ColumnDefinition;
import java.io.IOException;
import java.sql.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;

public abstract class AbstractBeanListEditor<E>
extends AbstractListEditor<E> {
    private static final long serialVersionUID = 1L;
    protected Class<E> beanClass;
    protected PojoModel beanModel;
    protected LinkedList<ColumnDefinition> columnDefinitions;
    private static Log log = Log.getLog(AbstractBeanListEditor.class);

    public AbstractBeanListEditor(Class<E> beanClass, String schema) {
        this.beanClass = beanClass;
        this.beanModel = new PojoParser().parse(beanClass).getModel();
        TreeMap<Integer, String> columns = new TreeMap<Integer, String>();
        int nextOrderId = 100;
        for (PojoAttribute descriptor : this.beanModel) {
            Column columnDef = (Column)descriptor.getAnnotation(Column.class);
            if (columnDef == null || (!MString.isEmpty((String)schema) || columnDef.schema().length != 0) && !MCollection.contains((Object[])columnDef.schema(), (Object)schema)) continue;
            int order = columnDef.order();
            if (order < 0) {
                order = ++nextOrderId;
            }
            columns.put(order, descriptor.getName());
        }
        this.columnDefinitions = new LinkedList();
        for (String colId : columns.values()) {
            PojoAttribute descriptor = this.beanModel.getAttribute(colId);
            Column columnDef = (Column)descriptor.getAnnotation(Column.class);
            ColumnDefinition def = new ColumnDefinition(colId, descriptor.getType(), this.createDefaultvalue(descriptor), MNls.find((MNlsProvider)this, (String)(columnDef.nls() + "=" + columnDef.title())), columnDef.elapsed(), this.createProperties(columnDef));
            this.columnDefinitions.add(def);
        }
    }

    private Properties createProperties(Column columnDef) {
        if (columnDef.properties() == null || columnDef.properties().length == 0) {
            return null;
        }
        return MProperties.explodeToProperties((String[])columnDef.properties());
    }

    @Override
    public void initUI() {
        super.initUI();
        for (ColumnDefinition def : this.columnDefinitions) {
            this.filter.addKnownFacetName(def.getId() + ":");
        }
    }

    protected Object createDefaultvalue(PojoAttribute<?> descriptor) {
        if (descriptor.getType() == String.class) {
            return "";
        }
        if (descriptor.getType() == Integer.TYPE) {
            return 0;
        }
        if (descriptor.getType() == Integer.class) {
            return 0;
        }
        if (descriptor.getType() == Long.TYPE) {
            return 0L;
        }
        if (descriptor.getType() == Long.class) {
            return 0L;
        }
        if (descriptor.getType() == Double.TYPE) {
            return 0.0;
        }
        if (descriptor.getType() == Double.class) {
            return 0.0;
        }
        if (descriptor.getType() == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (descriptor.getType() == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (descriptor.getType() == Boolean.TYPE) {
            return false;
        }
        if (descriptor.getType() == Boolean.class) {
            return false;
        }
        if (descriptor.getType() == Character.TYPE) {
            return Character.valueOf(' ');
        }
        if (descriptor.getType() == Character.class) {
            return Character.valueOf(' ');
        }
        if (descriptor.getType() == Byte.TYPE) {
            return (byte)0;
        }
        if (descriptor.getType() == Byte.class) {
            return (byte)0;
        }
        if (descriptor.getType() == Short.TYPE) {
            return (short)0;
        }
        if (descriptor.getType() == Short.class) {
            return (short)0;
        }
        if (descriptor.getType() == java.util.Date.class) {
            return new java.util.Date();
        }
        if (descriptor.getType() == Date.class) {
            return new Date(System.currentTimeMillis());
        }
        if (descriptor.getType() == UUID.class) {
            return UUID.randomUUID();
        }
        return null;
    }

    @Override
    protected ColumnDefinition[] createColumnDefinitions() {
        return this.columnDefinitions.toArray(new ColumnDefinition[this.columnDefinitions.size()]);
    }

    @Override
    protected Object[] getValues(E entry) {
        Object[] out = new Object[this.columnDefinitions.size()];
        int cnt = 0;
        for (ColumnDefinition def : this.columnDefinitions) {
            PojoAttribute attribute = this.beanModel.getAttribute(def.getId());
            try {
                Object value;
                out[cnt] = value = attribute.get(entry);
            }
            catch (Throwable t) {
                out[cnt] = def.getDefaultValue();
            }
            ++cnt;
        }
        return out;
    }

    @Override
    protected List<E> createDataList(FilterRequest filter) {
        return this.filterDataList(this.createBeanDataList(), filter);
    }

    protected abstract List<E> createBeanDataList();

    protected List<E> filterDataList(List<E> list, FilterRequest filter) {
        if (filter == null || !filter.isFiltering()) {
            return list;
        }
        LinkedList<E> out = new LinkedList<E>();
        for (E item : list) {
            if (!this.isPassFilter(item, filter)) continue;
            out.add(item);
        }
        return out;
    }

    protected boolean isPassFilter(E item, FilterRequest filter) {
        boolean ok = false;
        boolean done = false;
        block4: for (String mask : filter.getGeneralFilters()) {
            if (!MString.isSet((String)mask)) continue;
            done = true;
            for (PojoAttribute attr : this.beanModel) {
                try {
                    String value = this.valueOf(attr.get(item));
                    if (value == null || !MString.compareFsLikePattern((String)value.toLowerCase(), (String)mask.toLowerCase())) continue;
                    log.d(new Object[]{"filter match general", item, mask, value});
                    ok = true;
                    continue block4;
                }
                catch (IOException iOException) {
                }
            }
        }
        if (!done) {
            ok = true;
        }
        if (!ok) {
            return false;
        }
        done = false;
        ok = false;
        for (PojoAttribute attr : this.beanModel) {
            try {
                String facet = filter.getFacet(attr.getName());
                if (facet == null) continue;
                done = true;
                String value = this.valueOf(attr.get(item));
                if (value == null || !MString.compareFsLikePattern((String)value.toLowerCase(), (String)facet.toLowerCase())) continue;
                log.d(new Object[]{"filter match facet", item, attr.getName(), facet, value});
                return true;
            }
            catch (IOException iOException) {
            }
        }
        if (!done) {
            ok = true;
        }
        return ok;
    }

    private String valueOf(Object in) {
        if (in == null) {
            return null;
        }
        return String.valueOf(in);
    }
}

