/**
 * Copyright 2018 Mike Hummel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.mhus.lib.vaadin.desktop;

public interface Navigable {

	/**
	 * Navigate to a selected resource.
	 * 
	 * @param selection
	 * @param filter
	 * @return null if not possible or the title of the resource to display
	 */
	String navigateTo(String selection, String filter);

	/**
	 * If the space is shown without navigation.
	 * 
	 * @param firstTime
	 */
	void onShowSpace(boolean firstTime);
	
}
