/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.servlet;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import de.mhus.lib.vaadin.servlet.LocalVaadinServletService;
import de.mhus.lib.vaadin.servlet.ResourcesRequestWrapper;
import de.mhus.lib.vaadin.servlet.UidlRequestWrapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class VaadinLocalServlet
extends VaadinServlet {
    private static final long serialVersionUID = 1L;
    private String mappingPath = null;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.handleContextRootWithoutSlash(request, response)) {
            return;
        }
        if (this.mappingPath == null) {
            this.mappingPath = this.findMappingPath(request);
            this.getService().getDeploymentConfiguration().getInitParameters().setProperty("Resources", this.mappingPath);
        }
        if (this.isLocalUIDL(request)) {
            request = new UidlRequestWrapper(request);
        } else if (this.isLocalStaticResourceRequest(request)) {
            request = this.createLocalRequestMapper(request);
        }
        super.service(request, response);
    }

    protected String findMappingPath(HttpServletRequest request) {
        return request.getServletPath() + request.getPathInfo();
    }

    protected HttpServletRequest createLocalRequestMapper(HttpServletRequest request) {
        return new ResourcesRequestWrapper(request, this.getMappingPath());
    }

    protected boolean isLocalStaticResourceRequest(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        String uri = request.getRequestURI();
        return uri != null && uri.startsWith(this.mappingPath + "/VAADIN/");
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    protected boolean isLocalUIDL(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return false;
        }
        String uri = request.getRequestURI();
        return uri != null && uri.startsWith(this.getMappingPath() + "/UIDL/");
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        LocalVaadinServletService service = new LocalVaadinServletService(this, deploymentConfiguration);
        service.init();
        return service;
    }

    public String getServicePath() {
        return this.getMappingPath();
    }
}

