/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.vaadin.form2;

import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import de.mhus.lib.form.FormControl;
import de.mhus.lib.form.LayoutFactory;
import de.mhus.lib.form.control.ActivatorControl;
import de.mhus.lib.form.control.FocusManager;
import de.mhus.lib.form.control.InformationFocus;
import de.mhus.lib.form.pojo.LayoutModelByPojo;
import de.mhus.lib.vaadin.form2.VaadinFormBuilder;

public class VaadinPojoForm {
    private VaadinFormBuilder builder;
    private ActivatorControl control;
    private LayoutModelByPojo layout;
    private Object pojo;
    private ComponentContainer informationPane;

    public void doBuild(AbstractComponentContainer mainWindow) {
        try {
            this.builder = new VaadinFormBuilder();
            this.builder.setFormFactory(new LayoutFactory());
            this.builder.setInformationPane(this.informationPane);
            this.control = new ActivatorControl();
            this.control.setFocusManager((FocusManager)new InformationFocus());
            this.layout = new LayoutModelByPojo(this.pojo);
            this.layout.setFormControl((FormControl)this.control);
            this.layout.setFormFactory(this.builder.getFormFactory());
            this.layout.doBuild();
            this.builder.setRoot(this.layout.getModelRoot());
            this.builder.doBuild();
            this.builder.getRootComposit().setWidth("100%");
            mainWindow.addComponent((Component)this.builder.getRootComposit());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public VaadinFormBuilder getBuilder() {
        return this.builder;
    }

    public ActivatorControl getControl() {
        return this.control;
    }

    public LayoutModelByPojo getLayout() {
        return this.layout;
    }

    public Object getPojo() {
        return this.pojo;
    }

    public void setPojo(Object pojo) {
        this.pojo = pojo;
        if (this.layout != null) {
            this.getLayout().setPojo(pojo);
            this.getLayout().getDataSource().fireAll();
        }
    }

    public void setEnabled(boolean b) {
        if (this.builder != null) {
            this.getBuilder().getRootComposit().setEnabled(b);
        }
    }

    public void setInformationContainer(ComponentContainer informationPane) {
        this.informationPane = informationPane;
    }

    public static VaadinPojoForm createForm(Object pojo, AbstractComponentContainer content, ComponentContainer informationPane) {
        VaadinPojoForm form = new VaadinPojoForm();
        form.setPojo(pojo);
        if (informationPane != null) {
            form.setInformationContainer(informationPane);
        }
        if (content != null) {
            form.doBuild(content);
        }
        return form;
    }
}

